local utils = require("utils")
local xnaColors = require("consts.xna_colors")
local entity = {}

local function getEntityColor(entity)
    local rawColor = entity.color or "LightSkyBlue"
    local color = utils.getColor(rawColor) or xnaColors.LightSkyBlue

    return color
end

entity.name = "RainTools/RainControlledWater"
entity.depth = 9000
entity.nodeLimits = {4, 4}
entity.placements = {
    name = "RainControlledWater",
    data = {
        width = 8,
        height = 8,
        color = "LightSkyBlue",
        fillTime = 5,
        drainTime = 5,
        hasTop = true,
    }
}

entity.fieldInformation = {
    color = {
        fieldType = "color",
        allowXNAColors = true,
    }
}

entity.fillColor = function(room, entity)
    local color = getEntityColor(entity)

    return {color[1] * 0.3, color[2] * 0.3, color[3] * 0.3, 0.6}
end

entity.borderColor = function(room, entity)
    local color = getEntityColor(entity)

    return {color[1] * 0.8, color[2] * 0.8, color[3] * 0.8, 0.8}
end

return entity