local state = require("loaded_state")
local uiElements = require("ui.elements")
local notif = require("ui.notification")

local script =
{
    name = "decalCounter",
    displayName = "Decal Counter",
    tooltip = "Counts the number of decals in the map.",
}

function script.run()
    local bg, fg = 0, 0
    local map = state.map

    for _, room in ipairs(map.rooms) do
        bg = bg + #room.decalsBg
        fg = fg + #room.decalsFg
    end

    notif.notify(
        function(popup)
            return uiElements.label("BG decals: " .. tostring(bg) .. ", FG decals: " .. tostring(fg) .. ", Total: " .. tostring(bg+fg))
        end,
        5,
        {}
    )
end

return script