function playSprite(sprite, duration)
    player.DummyAutoAnimate = false
    player.Sprite:Play(sprite, false, false)
    if (duration) then
      wait(duration)
      player.DummyAutoAnimate = true
    end
  end

  local function doFadeWipe(state)
    fadeWipe = celeste.FadeWipe(engine.Scene, state)
    engine.Scene:Add(fadeWipe)
    fadeWipe.duration = 20;
    fadeWipe.EndTimer = 5;
end

  -- Parallel coroutine wrapper
local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

function onTalk()
    setFlag("flag_gravityOff", false)
    setFlag("flag_borderOn", true)
    disableMovement()
    wait(0.4)
    player.DummyAutoAnimate = false
    player.ForceCameraUpdate=true
    setFlag("flag_gravityOff", true)
    teleportTo(5316,62)
    player.Facing = getEnum("Celeste.Facings", "Left")
    local level = getLevel()
    level:add(coroutineEntity)
    coroutineEntity:add(monocle.Coroutine(player.Sprite:Play("sitDown", false, false)))
    coroutineEntity:add(wait(1))
    wait(2)

    if not getFlag("Flag_benchDialog1") and not getFlag("Flag_benchDialog2") then
        say("DIA_ESOTERICA_BENCH_A")
        setFlag("Flag_benchDialog1", true)
        
    elseif getFlag("Flag_benchDialog1") and not getFlag("Flag_benchDialog2") then
        say("DIA_ESOTERICA_BENCH_B")
        setFlag("Flag_benchDialog2", true)
        
    elseif getFlag("Flag_benchDialog1") and getFlag("Flag_benchDialog2") then
        say("DIA_ESOTERICA_BENCH_C")
        
    end


end




function onEnd()
    setFlag("flag_gravityOff", false)
    setFlag("flag_borderOn", false)
    enableMovement()
end