local exCamera = require("#ExtendedCameraDynamics.Code.Module.ExCameraCommands")
local audio = require("#Celeste.Audio")


function glitch(time)

	setFlag("woxens_Lucidity_glitch1",true)
	
	if time < 1 then
		audio.Play("event:/new_content/game/10_farewell/glitch_short")
	end
	
	if time >= 1 then
		audio.Play("event:/lucidity/sfx/glitch_longer")
	end

	wait(time)
	setFlag("woxens_Lucidity_glitch1",false)

end


function onTalk()
	audio.Play("event:/lucidity/sfx/activate_power")
	disableMovement()
	player.ForceCameraUpdate = true
	setFlag("woxens_Lucidity_lowcave_off",true)
	setFlag("woxens_Lucidity_powerwallstart",false)
	setFlag("woxens_Lucidity_powerwallon",true)
	wait(4.8)
	setFlag("woxens_Lucidity_fanson",true)
	wait(5.4)
	setFlag("woxens_Lucidity_lightning",true)
	wait(4.8)
	setDarkness(0.2)
	setFlag("woxens_lucidity_lightson",true)
	setFlag("woxens_Lucidity_bigcave_on",true)

	say("woxens_Lucidity_towerviewB")
	setFlag("woxens_Lucidity_towerviewout",true)
	local count = 1
	setFlag("woxens_Lucidity_bigcave_on2",true)

	while count < 420 do

		exCamera.UnsafeSetZoom(1-(count*0.002))

		if count == 320 or count == 385 or count == 400 then
			glitch(0.1)
		end

		count = count + 1
		wait(0.04)

	end

	setFlag("woxens_lucidity_lightson",false)
	glitch(1)
	exCamera.UnsafeSetZoom(-1)
	setFlag("woxens_Lucidity_blackout",true)
	setFlag("woxens_Lucidity_bigcave_off",true)
	wait(2.5)
	instantTeleportTo(930,-284,"sfm2")
	setFlag("woxens_Lucidity_mutedeath",true)
	die()
end

function onEnd()
	
	enableMovement()

end