--- Showing off callbacks available in the cutscene and brief explanations.
-- You are not required to define anything you aren't using.
-- Leave callbacks global to automatically detect it on c# side.
-- This assumes you know your way around Lua, if you don't then <a href=https://www.lua.org/pil/5.1.html>please consider reading the Lua PIL</a>.
-- <h2>Setting up in map editor</h2>
-- In the case of this cutscene, the filename for the entity field is "Assets/LuaCutscenes/example_cutscene".
-- Please use your own folders for your own cutscenes, like any other Celeste asset collisions can happen.<br>
-- <h2>Using C# in cutscene</h2>
-- Any imports from C# can be done with prefixing # in the require string. For example `local celeste = require("#Celeste")`.<br>
-- Check out helper_functions.lua for examples on C# interaction.
-- @module example_cutscene

--- Coroutine that is called when the cutscene starts.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
function onBegin()
    disableMovement()
    disableRetry()

    playMusic("", 0)
    local exCamera = require('#ExtendedCameraDynamics.Code.Module.ExCameraCommands')
    exCamera.ZoomToCameraReferenceFrame('unfree1', 1.5, true)
    say("GlerG_WalkingContradiction_WalkingContradiction_Ghost1")
    setFlag("body1", true)
    exCamera.ZoomToCameraReferenceFrame('unfree2', 0.75, true)
    wait(0.65)
    player.Facing = getEnum("Celeste.Facings", "Left")
    say("GlerG_WalkingContradiction_WalkingContradiction_Ghost2")
    setFlag("body1", false)
    setFlag("body2", true)
    playMusic("event:/GlerG_WalkingContradiction/Re-association", 0)
    wait(0.75)
    walkTo(5432, true, 1)
    wait(1)
    run(14, false, 1)
    setFlag("unfree_glitch0", true)
    wait(0.75)
    player.Facing = getEnum("Celeste.Facings", "Left")
    wait(0.25)
    walk(12, true, 1)
    wait(0.5)
    setFlag("unfree_glitch1", true)
    wait(1)
    setFlag("unfree_glitch2", true)
    wait(0.2)
    setFlag("unfree_glitch3", true)
    wait(0.5)
    setFlag("unfree_glitch4", true)
    wait(0.1)

end

--- Callback for when the cutscene ends.
-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
-- @tparam #Celeste.Level room Current room.
-- @bool wasSkipped If the cutscene was skipped.
function onEnd(room, wasSkipped)
    setFlag("unfree", true)
    setFlag("black_coverup", true)
    enableRetry()
    enableMovement()
end

--- Callback for when a player enters the trigger.
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that entered the trigger.
function onEnter(player)

end

--- Callback for when a player stays in the trigger (once per frame).
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that is staying in the trigger.
function onStay(player)

end

--- Callback for when a player leaves the trigger.
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that exited the trigger.
function onLeave(player)
    
end