﻿using System.Collections;
using Monocle;

namespace Celeste.Mod.OneHourChallenge;

public class GameOverScreen : Scene
{
    //private FakeFileSelectSlot fakeSlot;

    private readonly TextMenu deleteButtonMenu;
    private readonly TextMenu.Button deleteButton;

    public GameOverScreen(bool newBest)
    {
        Add(new HudRenderer());
        Add(deleteButtonMenu = new TextMenu());
        deleteButtonMenu.Add(new TextMenu.Header(Dialog.Clean("ONEHOURCHALLENGE_TIMEUP")));
        deleteButtonMenu.Add(new TextMenu.Header($"{Dialog.Clean("ONEHOURCHALLENGE_TIME")}: {ChallengeModule.IntToTime(ChallengeModule.SaveData.StartTime)}"));
        deleteButtonMenu.Add(new TextMenu.Header($"{ChallengeModule.CalcScore(SaveData.Instance)} {Dialog.Clean("ONEHOURCHALLENGE_POINTS")}"));
        deleteButtonMenu.Add(new TextMenu.Header($"{Dialog.Clean("ONEHOURCHALLENGE_BEST")} {ChallengeModule.Settings.BestScore}"));
        deleteButtonMenu.Add(new TextMenu.Header(newBest ? Dialog.Clean("ONEHOURCHALLENGE_NEWBEST") : ""));
        deleteButtonMenu.Add(deleteButton = new TextMenu.Button(""));
        //fakeSlot = new FakeFileSelectSlot(1, SaveData.Instance);
        //Add(fakeSlot);
        Entity e = new();
        Add(e);
        _ = new FadeWipe(this, wipeIn: true, onComplete: () => e.Add(new Coroutine(GameOverRoutine())));
    }

    private IEnumerator GameOverRoutine()
    {
        yield return 0.5f;

        //fakeSlot.Show();
        yield return 0.8f;

        deleteButton.Label = Dialog.Clean("ONEHOURCHALLENGE_DELETE");
        while (!Input.MenuConfirm.Pressed)
            yield return null;

        deleteButton.Disabled = true;
        //fakeSlot.FakeDelete();
        SaveData.TryDelete(SaveData.Instance.FileSlot); // spooky!

        yield return 0.3f;

        float timer = 1f;
        while (timer > 0 && !Input.MenuConfirm.Pressed)
        {
            timer -= Engine.DeltaTime;
            yield return null;
        }

        _ = new FadeWipe(
            this, wipeIn: false, onComplete: () =>
                Engine.Scene = new OverworldLoader(Overworld.StartMode.MainMenu)
        );
    }
}
