local utils = require("utils")
local rect = require('structs.drawable_rectangle')
local drawablesprite = require('structs.drawable_sprite')

local NailHittableSprite = {}

NailHittableSprite.name = "Kelper/NailHittableSprite"
NailHittableSprite.depth = 0
NailHittableSprite.warnBelowSize = {1,1}
NailHittableSprite.placements = {
    {
        name = "default",
        data = {
            width = 1,
            height = 1,
            spriteOffsetX = 0,
            spriteOffsetY = 0,
            spritePath = "objects/kelper/examples/swingthing/swingthing",
            hitSound = "",
            flag = "",
            consumeSwing = false,
            rebound = false,
            flipX = false,
            flipY = false,
            permanent = false,
            depth = 9000,
            animationSpeeds = "0|0.05|0"
        }
    }
}
NailHittableSprite.fieldInformation = {
    spriteOffsetX = { fieldType = "integer" },
    spriteOffsetY = { fieldType = "integer" },
    depth = { fieldType = "integer" },
}
NailHittableSprite.ignoredFields = {
    "_name", "_id", "_type", "x", "y", "width", "height"
}
NailHittableSprite.fieldOrder ={
    "spritePath", "hitSound", "flag", "depth", "spriteOffsetX", "spriteOffsetY", "animationSpeeds", "flipX", "flipY"
}

function NailHittableSprite.sprite(room, entity)
    local incolor = {1, 1, 1, 0.2}
    local outcolor = {1, 1, 1, 0.5}
    local sprite = entity.spritePath .. "00"

    local drawsprite = drawablesprite.fromTexture(sprite, entity):setPosition(entity.x + math.floor(entity.width/2) + entity.spriteOffsetX, entity.y+ math.floor(entity.height/2) + entity.spriteOffsetY):setScale(entity.flipX and -1 or 1, entity.flipY and -1 or 1)


    return {rect.fromRectangle("bordered",entity.x,entity.y, entity.width, entity.height, incolor, outcolor), drawsprite}
end

return NailHittableSprite