local spikeHelper = require("helpers.spikes")

local spikeUp = spikeHelper.createEntityHandler("Kelper/NailSpikesUp", "up", {})
local spikeDown = spikeHelper.createEntityHandler("Kelper/NailSpikesDown", "down", {})
local spikeLeft = spikeHelper.createEntityHandler("Kelper/NailSpikesLeft", "left", {})
local spikeRight = spikeHelper.createEntityHandler("Kelper/NailSpikesRight", "right", {})

spikeUp.direction = "up"
spikeDown.direction = "down"
spikeLeft.direction = "left"
spikeRight.direction = "right"

local spikes = {
    spikeUp,
    spikeDown,
    spikeLeft,
    spikeRight
}

local function getSpikePlacements(direction)
    local placements = {}
    local horizontal = direction == "left" or direction == "right"
    local lengthKey = horizontal and "height" or "width"

    local placement = {
        name = "spike",
        data = {
            Type = "kelper/nail/outline",
        }
    }

    placement.data[lengthKey] = 8

    return { placement }
end

-- Lönn spike helper copypaste begin
local drawableSprite = require("structs.drawable_sprite")

local spikeTexture = "danger/spikes/%s_%s00"

local spikeOffsets = {
    up = {0, 1},
    down = {0, -1},
    right = {-1, 0},
    left = {1, 0}
}

local spikeJustifications = {
    up = {0.0, 1.0},
    down = {0.0, 0.0},
    right = {0.0, 0.0},
    left = {1.0, 0.0}
}

local function getDirectionJustification(direction)
    return unpack(spikeJustifications[direction] or {0, 0})
end

local function getDirectionOffset(direction)
    return unpack(spikeOffsets[direction] or {0, 0})
end

local function getSpikeSpritesFromTexture(entity, direction, variant, texture)
    step = 8

    local horizontal = direction == "left" or direction == "right"
    local justificationX, justificationY = getDirectionJustification(direction)
    local offsetX, offsetY = getDirectionOffset(direction)
    local rotation = 0
    local length = horizontal and (entity.height or step) or (entity.width or step)
    local positionOffsetKey = horizontal and "y" or "x"

    local position = {
        x = entity.x,
        y = entity.y
    }

    local sprites = {}

    for i = 0, length - 1, step do
        -- Tentacles overlap instead of "overflowing"
        if i == length - step / 2 then
            position[positionOffsetKey] -= step / 2
        end

        local sprite = drawableSprite.fromTexture(texture, position)

        sprite.depth = spikeDepth
        sprite.rotation = rotation
        sprite:setJustification(justificationX, justificationY)
        sprite:addPosition(offsetX, offsetY)

        table.insert(sprites, sprite)

        position[positionOffsetKey] += step
    end

    return sprites
end

local function getNormalSpikeSprites(entity, direction)
    local variant = entity.Type or "default"
    local texture = string.format(spikeTexture, variant, direction)

    return getSpikeSpritesFromTexture(entity, direction, variant, texture)
end
-- Lönn spike helper copypaste end

local spikeTypes = {
    "kelper/nail/default",
    "kelper/nail/outline",
    "kelper/nail/white_default",
    "kelper/nail/white_outline",
    "kelper/nail/brown_default",
    "kelper/nail/brown_outline",
    "default",
    "outline",
    "reflection",
    "cliffside",
}

for _, spike in ipairs(spikes) do
    spike.placements = getSpikePlacements(spike.direction)

    local direction = spike.direction
    function spike.sprite(room, entity)
        return getNormalSpikeSprites(entity, direction)
    end

    spike.fieldInformation = {
        Type = {
            options = spikeTypes
        }
    }
end

spikeUp.selection = function (room, entity)
    return utils.rectangle(entity.x, entity.y-5, entity.width, 5)
end

spikeDown.selection = function (room, entity)
    return utils.rectangle(entity.x, entity.y, entity.width, 5)
end

spikeLeft.selection = function (room, entity)
    return utils.rectangle(entity.x-5, entity.y, 5, entity.height)
end

spikeRight.selection = function (room, entity)
    return utils.rectangle(entity.x, entity.y, 5, entity.height)
end



spikeUp.flip = function(room, entity, direction)
        entity._name = "Kelper/NailSpikesDown"
        entity.y = entity.y - 8
    return true
end

spikeDown.flip = function(room, entity, direction)
        entity._name = "Kelper/NailSpikesUp"
        entity.y = entity.y + 8
    return true
end

spikeLeft.flip = function(room, entity, direction)
        entity._name = "Kelper/NailSpikesRight"
        entity.x = entity.x - 8
    return true
end

spikeRight.flip = function(room, entity, direction)
        entity._name = "Kelper/NailSpikesLeft"
        entity.x = entity.x + 8
    return true
end

spikeUp.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "Kelper/NailSpikesRight"
        entity.y = entity.y - 8
    else
        entity._name = "Kelper/NailSpikesLeft"
        entity.x = entity.x + 8
        entity.y = entity.y - 8
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end

spikeDown.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "Kelper/NailSpikesLeft"
        entity.x = entity.x + 8
    else
        entity._name = "Kelper/NailSpikesRight"
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end

spikeLeft.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "Kelper/NailSpikesUp"
        entity.x = entity.x - 8
        entity.y = entity.y + 8
    else
        entity._name = "Kelper/NailSpikesDown"
        entity.x = entity.x - 8
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end

spikeRight.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "Kelper/NailSpikesDown"
    else
        entity._name = "Kelper/NailSpikesUp"
        entity.y = entity.y + 8
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end




return spikes