local nailRefill = {}

nailRefill.name = "Kelper/NailRefill"
nailRefill.depth = -100
nailRefill.placements = {
    {
        name = "one_dash",
        alternativeName = "one_dash_crystal",
        data = {
            oneUse = false,
            twoDash = false,
            textureFolder = "objects/kelper/nailRefill/oneDash",
        }
    },
    {
        name = "two_dashes",
        alternativeName = "two_dashes_crystal",
        data = {
            oneUse = false,
            twoDash = true,
            textureFolder = "objects/kelper/nailRefill/twoDash",
        }
    }
}

function nailRefill.texture(room, entity)
    if (entity.textureFolder == "" or entity.textureFolder == null) then
        if (entity.twoDash) then
            return "objects/kelper/nailRefill/twoDash/idle00"
        else 
            return "objects/kelper/nailRefill/oneDash/idle00"
        end 
    end

    return string.gsub(entity.textureFolder,"/$","") .. "/idle00"
end

return nailRefill