local booster = {
    name = "Kelper/NailBooster",
    ignoredFields = {
        "_name", "_id", "_type"
    },
    fieldInformation = {
        uses = { fieldType = "integer", minimumValue="-1" }
    },
    placements = {
        {
            name = "booster",
            data = {
                uses = -1,
                red = false,
                oneUse = false,
                textureFolder = "objects/kelper/nailBooster/",
            }
        }
    }
}

function booster.texture(room, entity)
    if entity.red then
        return string.gsub(entity.textureFolder,"/$","") .. "/boosterRed00"

    else
        return string.gsub(entity.textureFolder,"/$","") .. "/booster00"
    end
end

function booster.selection(room, entity)
    return utils.rectangle(entity.x - 11, entity.y - 11, 22, 22)
end

function booster.color(room, entity)
    if entity.oneUse then
        return {0.6, 0.6, 0.6}
    else
        return {1, 1, 1}
    end
end



return booster