local interactableEntity = {
    name = "Kelper/InteractableEntity",
    depth = -8500,
    placements = {
        {
            name = "kuksa/interactableEntity",
            data = {
                entitySprite = "interactable_sunny_cat",
                editorSprite = "objects/kelper/interactableEntity/interactable_sunny_cat/sunnycat00",
                playerAnimation = "kelper_pet",     
                playerSpriteID = "kelper_playerAnimations",
                flagToEnable = "",
                playerOffset = -9,
                interactionRadius = 24,
                indicator = false,
                flipX = false,
                flipPlayer = false,
                oneUse = false,
                showIndicatorWhenInRadius = true;
                depth = 1000
            },
        },
    },
    fieldInformation = {
        preset = {
            options = {'Brown Cat','Black Cat','Orange Cat','Gray Cat'},
            editable = true
        },
        playerOffset = { fieldType = "integer" },
        interactionRadius = { fieldType = "integer" },
        depth = { fieldType = "integer" }
    },
}



function interactableEntity.ignoredFields(entity)
    return {"_name", "_id", "originX", "originY", "playerSpriteID"}
end

function interactableEntity.fieldOrder(entity)
    return {"x", "y", "depth", "editorSprite", "playerOffset", "entitySprite", "interactionRadius", "playerAnimation", "flagToEnable"}
end

function interactableEntity.texture(room, entity)
    return entity.editorSprite
end

function interactableEntity.scale(room, entity)
    if (entity.flipX == true) then
        return {-1, 1}
    else
        return {1, 1}
    end
end

function interactableEntity.depth(room, entity, viewport)
    return entity.depth
end

return interactableEntity