
#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

#define pi 3.141592653f

DECLARE_TEXTURE(text, 0);
uniform int intensity = 3.0;
uniform float warpIntensity = 0.02;

float zigzagcos(float input)
{
    float normalProportion = abs(input % (2 * pi) - pi);
    return (normalProportion * cos(input) + (2/normalProportion)*(normalProportion / pi * 2 - 1)) / (normalProportion + 1/normalProportion);

}

int scanlines(float2 uv)
{
    return !(uv.y * 540 % 3 < 1 || (uv.x * 1920 % 6 < 1 && (uv.y * 1080 + 1) % 6 < 4) || (uv.y > 1 || uv.y < 0 || uv.x > 1 || uv.x < 0));
}

float4 chromaticScanlines(float4 inColor : COLOR0, float2 uv : TEXCOORD0) : COLOR0
{
    float2 newUV = (uv - float2(0.5, 0.5)) * (1 + warpIntensity - warpIntensity * zigzagcos(4 * atan(abs(uv.y - 0.5) / abs(uv.x - 0.5)))) + float2(0.5,0.5);
    float offsetAmount = 0.00052083333 * intensity;
    float2 redUV = float2(newUV);
    redUV.x = redUV.x - offsetAmount;
    float4 baseColorRed = SAMPLE_TEXTURE(text, redUV);
    float4 baseColorGreenBlue = SAMPLE_TEXTURE(text, newUV);
    float4 colorRed = scanlines(redUV) * baseColorRed * inColor;
    float4 colorGreenBlue = scanlines(newUV) * baseColorGreenBlue * inColor;
    return float4(colorRed.r, colorGreenBlue.g, colorGreenBlue.b, 1);
}

float4 cheapScanlines(float4 inColor : COLOR0, float2 uv : TEXCOORD0) : COLOR0
{
    float2 newUV = (uv - float2(0.5, 0.5)) * (1 + warpIntensity - warpIntensity * zigzagcos(4 * atan(abs(uv.y - 0.5) / (uv.x - 0.5)))) + float2(0.5, 0.5);
    float4 color = SAMPLE_TEXTURE(text, newUV) * inColor;
    return color * scanlines(newUV);
}

technique ScanlinesTechnique
{
    pass
    {
        PixelShader = compile ps_3_0 chromaticScanlines();
    }
}
technique CheapScanlinesTechnique
{
    pass
    {
        PixelShader = compile ps_3_0 cheapScanlines();
    }
}