local function dash(xVector, yVector)
  player.OverrideDashDirection = vector2(xVector, yVector)
  setPlayerState(2)
  wait(0.6)
  setPlayerState(11)
  player.OverrideDashDirection = nil
end

function onBegin()
  disableMovement()
  local level = getLevel()
  -- Zoom in 2x, focusing on the point (150, 150), over the next 3.5 seconds
  coroutine.yield(level:ZoomTo(vector2(150, 90), 1.1, 1))
  walk(32)
  wait(0.5)
  walk(8)
  dash(1,0)
  say("CommunityVoice_wildflowers_BADELINE_1")
  walk(8)
  setFlag("badeline", true)
  say("CommunityVoice_wildflowers_BADELINE_2")
  coroutine.yield(level:ZoomBack(2))
end

function onEnd()
  setFlag("badeline", true)
  enableMovement()
end