function getCounter(key)
    return engine.Scene.Session:GetCounter(key)
end

function getSlider(key)
    return engine.Scene.Session:GetSlider(key)
end

function setCounter(key, value)
    return engine.Scene.Session:SetCounter(key, value)
end

function setSlider(key, value)
    return engine.Scene.Session:SetSlider(key, value)
end

function makeUpgradeReq(prefix, level)
    return function(ctx)
        return  not getFlag("boughtUpgrade"..prefix..level)
    end
end

function makeBuildingReq(buildingNumber, buildingCount, level)
    return function(ctx)
        return getCounter("b"..buildingNumber.."Count") >= buildingCount and not getFlag("upgradeb"..buildingNumber.."c"..level)
    end
end

function makeUpgradeBehavior(cost, prefix, level)
    return function(ctx)
        if getSlider("playerScore") >= cost then
            setSlider("playerScore", getSlider("playerScore") - cost)
            setCounter(prefix, getCounter(prefix) + 1)
            setFlag(prefix..level, true)
            setFlag("updateCPS", true)
            setFlag("updateCPC", true)
            setFlag("updateBuildingCPS", true)
            setCounter("upgradesPurchased", getCounter("upgradesPurchased") + 1)
        else
            say("CommunityVoice_strawsim_tooexpensive")
        end
        
    end
end

function makeBuildingUpgrades(table, offset)
    local buildings = {"refill", "granny", "badeline", "bunny", "feather", "temple", "kevin", "mountain", "heart", "moon"}
    local counts = {1, 5, 25, 50, 100}
    local costs = {
        {100, 500, 10000, 100000, 10000000},
        {1000, 5000, 50000, 5000000, 500000000},
        {11000,55000,550000,55000000,5500000000},
        {120000,600000,6000000,600000000,60000000000},
        {1300000,6500000,65000000,6500000000,650000000000},
        {14000000,70000000,700000000,70000000000,7000000000000},
        {200000000,1000000000,10000000000,1000000000000,100000000000000},
        {3300000000,16500000000,165000000000,16500000000000,1650000000000000},
        {51000000000,255000000000,2550000000000,255000000000000,25500000000000000},
        {750000000000,3750000000000,37500000000000,3750000000000000,375000000000000000}
    }
    for i = 1, 10, 1 do
        for e = 1, 5, 1 do
            table[offset + ((i - 1) * 5) + e] = {"CommunityVoice_strawsim_"..buildings[i]..e, repeatable = true, requires = makeBuildingReq(i, counts[e], e), onChosen = makeUpgradeBehavior(costs[i][e], "upgradeb"..i.."c", e), cost = costs[i][e]}
        end
    end
end

function onBegin()

    disableMovement()
    setPlayerState(17)
    player.Speed = vector2(0,0)
    dialogTable = {
        {
            "CommunityVoice_strawsim_closemenu",
            onChosen = function ()
                closeChoiceDialog()
            end,
            cost = -1
        },
        -- Dash upgrades
        { "CommunityVoice_strawsim_dash1", repeatable = true, requires = function (ctx) return getSlider("handMadeBerries") >= 1000 and not getFlag("upgradeDash1") end, onChosen = makeUpgradeBehavior(50000, "upgradeDash", 1), cost = 50000},
        { "CommunityVoice_strawsim_dash2", repeatable = true, requires = function (ctx) return getSlider("handMadeBerries") >= 100000 and not getFlag("upgradeDash2") end, onChosen = makeUpgradeBehavior(5000000, "upgradeDash", 2), cost = 5000000},
        { "CommunityVoice_strawsim_dash3", repeatable = true, requires = function (ctx) return getSlider("handMadeBerries") >= 10000000 and not getFlag("upgradeDash3")end, onChosen = makeUpgradeBehavior(500000000, "upgradeDash", 3), cost = 500000000},
        { "CommunityVoice_strawsim_dash4", repeatable = true, requires = function (ctx) return getSlider("handMadeBerries") >= 1000000000 and not getFlag("upgradeDash4")end, onChosen = makeUpgradeBehavior(50000000000, "upgradeDash", 4), cost = 50000000000},
        { "CommunityVoice_strawsim_dash5", repeatable = true, requires = function (ctx) return getSlider("handMadeBerries") >= 100000000000 and not getFlag("upgradeDash5") end, onChosen = makeUpgradeBehavior(500000000000, "upgradeDash", 5), cost = 500000000000},
    }

    makeBuildingUpgrades(dialogTable, 5)

    table.sort(dialogTable, function (a,b) return a.cost < b.cost end)

    choiceDialog(dialogTable)
end

function onEnd(room, wasSkipped)
    enableMovement()
    setPlayerState(0)
end