﻿using Microsoft.Xna.Framework;
using Monocle;
using System;

namespace Celeste.Mod.LakeSideCode
{
    public static class Utils
    {
        public static void DrawRectCentered(float centerX, float centerY, float width, float height, Color color)
        {
            float x = centerX - width / 2;
            float y = centerY - height / 2;
            Draw.Rect(x, y, width, height, color);
        }

        // yes this ends up with the corners missing, but i'm leaving that because it looks nice for this
        public static void DrawHollowRect(float x, float y, float width, float height, Color color, float thickness)
        {
            Draw.Line(x, y, x + width, y, color, thickness);
            Draw.Line(x + width, y, x + width, y + height, color, thickness);
            Draw.Line(x + width, y + height, x, y + height, color, thickness);
            Draw.Line(x, y + height, x, y, color, thickness);
        }

        public static void DrawHollowRectCentered(float centerX, float centerY, float width, float height, Color color, float thickness)
        {
            float x = centerX - width / 2;
            float y = centerY - height / 2;
            DrawHollowRect(x, y, width, height, color, thickness);
        }

        public static void DrawOutlineRect(float x, float y, float width, float height, Color fillColor, Color outlineColor, float thickness)
        {
            Draw.Rect(x, y, width, height, fillColor);
            DrawHollowRect(x, y, width, height, outlineColor, thickness);
        }

        public static void DrawOutlineRectCentered(
            float centerX, float centerY, float width, float height, Color fillColor, Color outlineColor, float thickness)
        {
            DrawRectCentered(centerX, centerY, width, height, fillColor);
            DrawHollowRectCentered(centerX, centerY, width, height, outlineColor, thickness);
        }

        public static int Mod(int x, int m)
        {
            return (x % m + m) % m;
        }
    }
}
