﻿using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Celeste.Mod.LakeSideCode.Triggers {

	[CustomEntity("LakeSideCode/CookTrigger")]
	public class CookTrigger : Trigger {

		private string reqFlag;
		public bool FlagCheck => string.IsNullOrEmpty(reqFlag) || SceneAs<Level>()?.Session?.GetFlag(reqFlag) == true;

		public CookTrigger(EntityData data, Vector2 offset) : base(data, offset) {
			reqFlag = data.Attr("requiredFlag", "");
		}
	}
}
