﻿using Microsoft.Xna.Framework;
using Monocle;

namespace Celeste.Mod.LakeSideCode
{
    /// <summary>
    ///   Static methods for drawing Button labels, but the other way around from
    ///   how <see cref="ButtonUI"/> does it.
    ///   </summary>
    public static class ReverseButtonUI
    {
        /// <summary>
        ///   Get the total rendered width of a label and button icon.
        ///   </summary>
        /// <param name="label">Displayed text.</param>
        /// <param name="button">Displayed button.</param>
        /// <returns>
        /// </returns>
        public static float Width(string label, VirtualButton button)
        {
            MTexture buttonTexture = GuiButton(button);
            return ActiveFont.Measure(label).X + 8f + buttonTexture.Width;
        }

        /// <summary>
        ///   Draw text and a button icon on screen.<br />
        ///   Button icon retrieved using <see cref="M:Celeste.Input.GuiButton(Monocle.VirtualButton,System.String)" />.
        ///   </summary>
        /// <param name="position">Position on screen.</param>
        /// <param name="label">Displayed text.</param>
        /// <param name="button">Displayed button.</param>
        /// <param name="scale">
        /// </param>
        /// <param name="wiggle">
        /// </param>
        /// <param name="alpha">
        /// </param>
        public static void Render(Vector2 position, string label, VirtualButton button, float scale, float wiggle = 0f, float alpha = 1f)
        {
            MTexture buttonTexture = GuiButton(button);
            float width = Width(label, button);
            //position.X -= scale * width * (justifyX - 0.5f);
            buttonTexture.Draw(position, new Vector2(0f, buttonTexture.Height / 2f), Color.White * alpha, scale + wiggle);
            position.X += (buttonTexture.Width + 13f) * scale; // i don't even care anymore
            DrawText(label, position, scale + wiggle, alpha);
        }

        private static void DrawText(string text, Vector2 position, float scale, float alpha)
        {
            float x = ActiveFont.Measure(text).X;
            ActiveFont.DrawOutline(text, position, new Vector2(0f, 0.5f), Vector2.One * scale, Color.White * alpha, 2f, Color.Black * alpha);
        }

        // why are there even two overloads of this method
        // i shouldn't have to do this, this is dumb
        private static MTexture GuiButton(VirtualButton button)
        {
            return Input.GuiButton(button, "controls/keyboard/oemquestion");
        }
    }
}
