﻿using System;
using Celeste.Mod.LakeSideCode.Components;
using Celeste.Mod.LakeSideCode.Triggers;
using Microsoft.Xna.Framework;

namespace Celeste.Mod.LakeSideCode;

public class LakeSideCodeModule : EverestModule
{
    public static LakeSideCodeModule Instance { get; private set; }

    public override Type SettingsType => typeof(LakeSideCodeModuleSettings);
    public static LakeSideCodeModuleSettings Settings => (LakeSideCodeModuleSettings)Instance._Settings;

    public override Type SessionType => typeof(LakeSideCodeModuleSession);
    public static LakeSideCodeModuleSession Session => (LakeSideCodeModuleSession)Instance._Session;

    public override Type SaveDataType => typeof(LakeSideCodeModuleSaveData);
    public static LakeSideCodeModuleSaveData SaveData => (LakeSideCodeModuleSaveData)Instance._SaveData;

    public LakeSideCodeModule()
    {
        Instance = this;
#if DEBUG
        // debug builds use verbose logging
        Logger.SetLogLevel(nameof(LakeSideCodeModule), LogLevel.Verbose);
#else
            // release builds use info logging to reduce spam in log files
            Logger.SetLogLevel(nameof(LakeSideCodeModule), LogLevel.Info);
#endif
    }

    public override void Load()
    {
        TerminalTrigger.Load();
        Everest.Events.Player.OnRegisterStates += OnRegisterPlayerStates;
    }

    public override void Unload()
    {
        TerminalTrigger.Unload();
		Everest.Events.Player.OnRegisterStates -= OnRegisterPlayerStates;
	}

	private void OnRegisterPlayerStates(Player player) {
        int stateID = player.AddState("LakeSideCode_Fishing", Fishing.StaticStateUpdate, Fishing.StaticStateCorou, Fishing.StaticStateBegin, null);
        player.Add(new Fishing(stateID));
	}

}