﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace Celeste.Mod.LakeSideCode.FishDefs
{
	public enum FishType
	{
		Nothing,
		Coin,
		Bass,
		Trout,
		Spring,
		Stone,
		StoneEater,
		Blahaj,
		Bomb,
		Leaf,
		Angel,
		Devil,
		Cooked,
		Mythic,
	}

	public static class FishTypeUtil {

		public static string DialogName(FishType type) {
			string fishName = type switch {
				FishType.Coin => "COIN",
				FishType.Bass => "BASS",
				FishType.Trout => "TROUT",
				FishType.Spring => "SPRING",
				FishType.Stone => "STONE",
				FishType.StoneEater => "STONEEATER",
				FishType.Blahaj => "BLAHAJ",
				FishType.Bomb => "BOMB",
				FishType.Leaf => "LEAF",
				FishType.Angel => "ANGEL",
				FishType.Devil => "DEVIL",
				FishType.Cooked => "COOKED",
				FishType.Mythic => "FORTNITE",
				_ => throw new Exception($"Unknown FishType: {type}")
			};
			
			return $"LAKESIDE_FISH_{fishName}_NAME";
		}

		public static string TexPath(FishType type, FishType? second = null, bool smaller = false) {
			string fishTex = type switch {
				FishType.Coin => "coin",
				FishType.Bass => "bass",
				FishType.Trout => "trout",
				FishType.Spring => "spring",
				FishType.Stone => "stone",
				FishType.StoneEater => "stoneeater",
				FishType.Blahaj => "blahaj",
				FishType.Bomb => "bomb",
				FishType.Leaf => "leaf",
				FishType.Angel => second == FishType.Devil ? "angelguppy" : "angel",
				FishType.Devil => second == FishType.Angel ? "angelguppy" : "devil",
				FishType.Cooked => "cooked",
				FishType.Mythic => "fortnite",
				_ => throw new Exception($"Unknown FishType: {type}")
			};
			return $"objects/Phobscodestuff/Lakesidecodestuff/fish/{(smaller ? "smaller/" : "")}{fishTex}";
		}

	}
}
