using System;
using System.Collections;
using Celeste.Mod.LakeSideCode.FishDefs;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Monocle;

namespace Celeste.Mod.LakeSideCode.Entities {
	public class NewfishPopup : Entity {
        private VirtualRenderTarget newFishTarget;
        private FishType fishType;
        private float scaleLerp = 0.0f;

        private Sprite sprite;

        public NewfishPopup(FishType type) : base() {
            Tag = Tags.HUD | Tags.Global;

            fishType = type;

            sprite = GFX.SpriteBank.Create("LakeSideCode_3DFISH");

            Add(new BeforeRenderHook(BeforeRender));
        }

        public override void Added(Scene scene)
        {
            base.Added(scene);

            Add(new Coroutine(NewFishCoroutine()));
            Add(sprite);
            sprite.Visible = false;
            try {
                sprite.Play($"LakeSideCode_{Enum.GetName(typeof (FishType), this.fishType)}");
            } catch {
                sprite.Play($"LakeSideCode_Trout");
            }
        }

        private IEnumerator NewFishCoroutine() {
            while (scaleLerp < 1) {
                scaleLerp += Engine.DeltaTime / 0.3f;

                yield return null;
            }

            scaleLerp = 1f;

            yield return 4f;

            while (scaleLerp > 0) {
                scaleLerp -= Engine.DeltaTime / 0.3f;

                yield return null;
            }

            scaleLerp = 0f;

            RemoveSelf();
        }

        public void BeforeRender() {
            if(Scene.Paused) return;

            newFishTargetRender();
        }

        private void newFishTargetRender() {
            if (newFishTarget == null) {
                newFishTarget = VirtualContent.CreateRenderTarget("lakeside-new-fish-target", 1920, 1080);
            }

            Engine.Graphics.GraphicsDevice.SetRenderTarget(newFishTarget);
            Engine.Graphics.GraphicsDevice.Clear(Color.Transparent);
            // Draw.SpriteBatch.Begin(SpriteSortMode.FrontToBack, BlendState.AlphaBlend,
			// 	SamplerState.PointWrap, DepthStencilState.None, RasterizerState.CullCounterClockwise);

            Draw.SpriteBatch.Begin(SpriteSortMode.Deferred, BlendState.AlphaBlend, SamplerState.PointWrap, DepthStencilState.None, RasterizerState.CullCounterClockwise);

            MTexture texture = sprite.Texture;

            texture.DrawCentered(new Vector2(1920/2, 1080/2), Color.White, 2f);

            // Utils.DrawRectCentered(1920/2, 1080/2, 500, 500, Color.Red);

            string fishName = Dialog.Get(FishTypeUtil.DialogName(fishType));

            ActiveFont.DrawOutline(fishName, new Vector2(1920/2, 1080/4), new Vector2(0.5f, 0), Vector2.One * 1.75f, Color.White, 3, Color.Black);

            Draw.SpriteBatch.End();
        }

        public override void Render() {
            base.Render();

            if(Scene.Paused) return;

            newFishRender();
        }

        private void newFishRender() {
            if(newFishTarget != null) {
                //thank you ssm

                Draw.SpriteBatch.Draw(newFishTarget,
                    new Vector2(1920/2, 1080/2), newFishTarget.Bounds, Color.White, 0f, new Vector2(1920/2, 1080/2), Ease.CubeInOut(scaleLerp), SpriteEffects.None, 0f);
            }
        }
    }
}