﻿using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;
using Monocle;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Celeste.Mod.LakeSideCode.Entities {
	[CustomEntity("LakeSideCode/FishingRodBarrel")]
	public class FishingRodBarrel : Entity {
		private static MTexture WithRod = null;
		private static MTexture WithoutRod = null;

		private static bool PlayerHasRod => LakeSideCodeModule.Session?.HasFishingRod == true;
		private static MTexture CurrentTexture => PlayerHasRod ? WithoutRod : WithRod;

		private Image image;
		private TalkComponent talkComponent;

		public FishingRodBarrel(EntityData data, Vector2 offset) : base(data.Position + offset - Vector2.One * 8f) {
			Collider = new Hitbox(24, 24);
			Depth = Depths.NPCs;
			WithRod ??= GFX.Game["objects/Phobscodestuff/Lakesidecodestuff/FishingRodBarrel/barrelA"];
			WithoutRod ??= GFX.Game["objects/Phobscodestuff/Lakesidecodestuff/FishingRodBarrel/barrelB"];
		}

		public override void Added(Scene scene) {
			base.Added(scene);
			Add(image = new Image(CurrentTexture));
			if (!PlayerHasRod) {
				Add(talkComponent = new TalkComponent(
					new Rectangle(-8, 12, (int)Width + 16, 12),
					new Vector2(12, 0), OnInteract));
			}
		}

		private void OnInteract(Player player) {
			LakeSideCodeModule.Session.HasFishingRod = true;
			player.SceneAs<Level>().Session.SetFlag("LS_FishingRodFlag");
			image.Texture = CurrentTexture;
			talkComponent.RemoveSelf();
			talkComponent = null;
			Input.Dash.ConsumePress();
		}
	}
}
