import os

def rename_images(folder_path, name, start_num):
    # List all files in the folder
    files = os.listdir(folder_path)
    # Filter out only PNG files
    images = [f for f in files if f.lower().endswith('.png')]
    
    # Sort images to ensure a consistent order
    images.sort()
    
    num = start_num
    for image in images:
        # Create the new name for the image
        new_name = f"{name}{num}.png"
        # Construct the full paths for the old and new filenames
        old_path = os.path.join(folder_path, image)
        new_path = os.path.join(folder_path, new_name)
        
        # Rename the file
        os.rename(old_path, new_path)
        print(f"Renamed '{old_path}' to '{new_path}'")
        
        # Increment the number for the next file
        num += 1

# Example usage:
rename_images('./', 'bangs', 319)