local calc = require("#Monocle.Calc")
local monocle = require("#Monocle")
local colors = require("#Microsoft.Xna.Framework.Color")

local function heartSlowDown()
    local frameCounter = 0

    monocle.engine.TimeRate = 0.5
    player.Depth = -2000000

    particleAbsorbBurst(25)
    engine.Scene:Flash(colors.White)
    engine.Scene:Shake()
    engine.Scene.FormationBackdrop.Display = true
    engine.Scene.FormationBackdrop.Alpha = 0.6

    while monocle.engine.TimeRate < 1 do
        if frameCounter % 2 == 0 then
            particleAbsorbBurst(1)
        end

        monocle.engine.TimeRate = calc.Approach(monocle.engine.TimeRate, 1, monocle.engine.RawDeltaTime * 0.5)
        frameCounter = frameCounter + 1

        coroutine.yield(0)
    end

    monocle.engine.TimeRate = 1
    player.Depth = 0
end

function onBegin()
    makeUnskippable()
    setFlag("flag_light", false)
    engine.Scene:Flash(colors.White)
    engine.Scene:Shake()
    engine.Scene.FormationBackdrop.Display = true
    local fade = 0.05
	while fade < 3 do
		engine.Scene.FormationBackdrop.Alpha = fade
		fade = fade + 0.05
		wait(0.1)
	end
end

function onEnter()
end

function onLeave()
    engine.Scene:Flash(colors.White)
    engine.Scene:Shake()
	engine.Scene.FormationBackdrop.Display = false
    engine.Scene.FormationBackdrop.Alpha = 0
end