module TREEWire
using ..Ahorn, Maple

@pardef WireLamp(x1::Integer, y1::Integer, x2::Integer=x1 + 8, y2::Integer=y1, above::Bool=false, WireColor::String="595866", LampColors::String="ff0000,ffffff,0000ff", NumberOfLamps::Integer=3) = Entity("TREE/WireLamp", x=x1, y=y1, nodes=Tuple{Int, Int}[(x2, y2)], above=above, WireColor=WireColor, LampColors=LampColors, NumberOfLamps=NumberOfLamps)

const placements = Ahorn.PlacementDict(
    "Wire With Lamps" => Ahorn.EntityPlacement(
        WireLamp,
        "line"
    )
)

const colors = sort(collect(keys(Ahorn.XNAColors.colors)))

function ColorFix(v, alpha::Float64) # v is string, either hex code or XNA Color
    if v in colors
        w = get(Ahorn.XNAColors.colors, v, (1.0, 1.0, 1.0, 1.0))
        return (w[1], w[2], w[3], alpha)
    else
        temp = Ahorn.argb32ToRGBATuple(parse(Int, v, base=16))[1:3] ./ 255
        color = (temp[1], temp[2], temp[3], alpha)
        return color
    end
    return (1.0, 1.0, 1.0, 1.0)
end

Ahorn.nodeLimits(entity::WireLamp) = 1, 1

function Ahorn.selection(entity::WireLamp)
    nodes = get(entity.data, "nodes", ())
    x, y = Ahorn.position(entity)

    res = Ahorn.Rectangle[Ahorn.Rectangle(x - 4, y - 4, 8, 8)]

    for node in nodes
        nx, ny = node

        push!(res, Ahorn.Rectangle(nx - 4, ny - 4, 8, 8))
    end

    return res
end

wireColorHex = "595866"
wireColor = (89, 88, 102, 1) ./ (255, 255, 255, 1)
wireColorSelected = (Ahorn.colors.selection_selected_fc)

function renderWire(ctx::Ahorn.Cairo.CairoContext, entity::WireLamp, color::Ahorn.colorTupleType=wireColor)
    x, y = Ahorn.position(entity)

    start = (x, y)
    stop = get(entity.data, "nodes", [start])[1]
    control = (start .+ stop) ./ 2 .+ (0, 24)

    curve = Ahorn.SimpleCurve(start, stop, control)
    Ahorn.drawSimpleCurve(ctx, curve, color, thickness=1)
end

Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::WireLamp) = renderWire(ctx, entity, wireColorSelected)

function Ahorn.renderAbs(ctx::Ahorn.Cairo.CairoContext, entity::WireLamp, room::Maple.Room)
    # Make sure Alpha is 1
    rawColor = Ahorn.argb32ToRGBATuple(parse(Int, get(entity.data, "WireColor", wireColorHex), base=16))[1:3] ./ 255
    color = (rawColor..., 1.0)

    renderWire(ctx, entity, color)
end

end
