local exports = {}




-- local lua = require("Assets/LuaCutscenes/helper_functions")
local expect = require("Assets/Cutscenes/RotationCollab/expect")
local tablex = require("Assets/Cutscenes/RotationCollab/tablex")


local Calc = require("#Monocle.Calc")
local Coroutine = require("#Monocle.Coroutine")
local Ease = require("#Monocle.Ease")
local Engine = require("#Monocle.Engine")
local Tween = require("#Monocle.Tween")

local Celeste = require("#Celeste")
local CelesteMod = require("#Celeste.Mod")
local Audio = require("#Celeste.Audio")
local Buses = require("#Celeste.Buses")
local CutsceneEntity = require("#Celeste.CutsceneEntity")

local LuaHelper = require("#Celeste.Mod.LuaCutscenes.LuaHelper")

local DynamicData = require("#MonoMod.Utils.DynamicData")

function exports.muteMusic(mute)
  expect(1, mute, "boolean")
  Audio.BusPaused(Buses.MUSIC, mute);
end

function exports.fadeMusic(fade)
  Audio.SetMusicParam("fade", fade);
end

function exports.setSessionMusic(event)
  local state = helpers.getRoom().Session.Audio
  local music = state.Music

  if event == nil then
    music.Event = "event:/none"
    state:Stop(true)
  else
    music.Event = event
  end
  state:Apply(false)
end


function exports.tween(func, duration, opts)
  expect(1, func, "function")
  expect(2, duration, "number")
  opts = expect(3, opts, "table", "nil") or {}
  opts = tablex.apply({
    oncomplete = nil, entity = helpers.getEntity("Player"),
    ease = Ease.SineInOut, mode = helpers.getEnum("Monocle.Tween.TweenMode", "Oneshot")
  }, opts)

  expect.field(opts, "oncomplete", "function", "nil")
  -- expect.field(opts, "entity", "table", "nil")
  -- expect.field(opts, "ease", "table", "nil")
  -- expect.field(opts, "mode", "table", "nil")

  Tween.Set(opts.entity, opts.mode, duration, opts.ease, func, opts.oncomplete)
end

function exports.routine(func)
  local enumerator
  if type(func) == "function" then
    enumerator = LuaHelper.LuaCoroutineToIEnumerator(coroutine.create(func))
  elseif type(func) == "thread" then
    enumerator = LuaHelper.LuaCoroutineToIEnumerator(func)
  elseif type(func) == "table" then
    -- pray it's already an IEnumerator
    enumerator = func
  end

  return Coroutine(enumerator)
end

function exports.get_camera()
  return helpers.getLevel().Camera.Position
end

function exports.pan_to(target, duration, ease)
  return CutsceneEntity.CameraTo(
    target,
    duration or 2.0,
    ease or nil
  )
end

function exports.get_flag(flag)
  if flag:match("^!") ~= nil then
    return not helpers.getFlag(flag:sub(2))
  else
    return helpers.getFlag(flag)
  end
end

function exports.set_flag(flag, set_to)
  if flag:match("^!") ~= nil then
    helpers.setFlag(flag:sub(2), not set_to)
  else
    helpers.setFlag(flag, set_to)
  end
end


return exports
