-- blame luacutscene's globals for this jank
_G.helpers = helpers
_G.player = player
_G.cutsceneEntity = cutsceneEntity
_G.cutsceneTrigger = cutsceneTrigger
_G.modMetaData = modMetaData
_G.arguments = arguments

local Calc = require("#Monocle.Calc")
local Coroutine = require("#Monocle.Coroutine")
local Ease = require("#Monocle.Ease")
local Engine = require("#Monocle.Engine")
local Tween = require("#Monocle.Tween")
local Celeste = require("#Celeste")
local CelesteMod = Celeste.Mod
local Audio = require("#Celeste.Audio")
local Buses = require("#Celeste.Buses")
local DynamicData = require("#MonoMod.Utils").DynamicData -- not sure this is even ever used in this file
local dzhake = require("#Celeste.Mod.DzhakeHelper.Utils").Lua -- multiverses first dzhake helper usage
local util = require("Assets/Cutscenes/RotationCollab/util")
local tablex = require("Assets/Cutscenes/RotationCollab/tablex")

arguments = tablex.apply({
  x = 0, y = 0, flag = nil, t_in = 2.0, t_wait = 1.5, t_out = 2.0
}, arguments)

local from
local ended = false

function onTalk()
  onEnter()
end

function onBegin()
  disableMovement()
  waitUntilOnGround()

  if arguments.flag then
    if util.get_flag(arguments.flag) then return end

    util.set_flag(arguments.flag, true)
  end

  from = util.get_camera()
  coroutine.yield(
    util.pan_to(
      getLevel().LevelOffset + vector2(arguments.x, arguments.y),
      arguments.t_in
    )
  )
  wait(arguments.t_wait)
  coroutine.yield(util.pan_to(from, arguments.t_out))
  ended = true
end

function onEnd(room, wasSkipped)
  enableMovement()
  if not ended then
    util.routine(util.pan_to(from, 0.5))
  end
end
