--- Coroutine that is called when the cutscene starts.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
function onTalk()
end

local Engine = require("#monocle.engine")
local Calc = require("#monocle.calc")
local Ease = require("#monocle.ease")
local minput = require("#Monocle.MInput")
local wasDashAssistOn = false
-- TY MICROLITH
function onBegin()
  setFlag("Ladder_Real", false)
  setFlag("MusicBaddyA", false)
  -- Flags
  
  disableRetry()
  disableMovement()
  -- movement/retry
  
  player.DummyAutoAnimate = false
  player.Sprite.Play(player.Sprite, "sitDown")
  player.Sprite:SetAnimationFrame(player.Sprite.CurrentAnimationTotalFrames - 1)
  -- Anim Junks
  
  wait(2.5)
  say("RotationCollab_Lobby_Baddy_A")
  playSound("event:/char/badeline/appear")
  setFlag("MusicBaddyA", false)
  wait(0.1)
  playSound("event:/char/badeline/level_entry")
  wait(0.1)
  playSound("event:/char/badeline/dash_red_right")
  engine.Scene:DirectionalShake({ x = 100, y = 100 }, 0.3)
  --badeline apears
  
  npc = getEntity("MoreCustomNPC", "Celeste.Mod.MaxHelpingHand.Entities.")
  --get the badeline ship entity
  local particles = getEntities("ParticleEmitter", "Celeste.Mod.FemtoHelper.")
  --get the badeline shp particles entity
  local particle
  for i, e in ipairs(particles) do
    if not particle or particle.Y < e.Y then
      particle = e
    end
  end
  --get the lowest one bc theres two particle emitters
  
  local npc_from = npc.Position
  --do this one once
  local npc_to = vector2(npc.Position.X + 250, npc.Position.Y - 110)
  local particle_from = particle.Position
  --do this one once
  local particle_to = vector2(particle.Position.X + 250, particle.Position.Y - 110)
  --set the easing locations

  local num_seconds = 1
  for t = 0, num_seconds, Engine.DeltaTime do
    npc.Position = npc_from + (npc_to - npc_from) * Ease.CubeInOut(t)
    particle.Position = particle_from + (particle_to - particle_from) * Ease.CubeInOut(t)
    wait()
  end
  -- do the easing, + badelne rocket car apears
  
  wait(0.2)
  setFlag("MusicBaddyA", true)
  say("RotationCollab_Lobby_Baddy_B")
  --music + dialog
  wait(1.5)
  
  npc_from = npc.Position
  npc_to = vector2(npc.Position.X - 50, npc.Position.Y - 0)
  
  particle_from = particle.Position
  particle_to = vector2(particle.Position.X - 50, particle.Position.Y - 0)
  playSound("event:/char/badeline/dash_red_right")
  
  for t = 0, num_seconds, Engine.DeltaTime do
    npc.Position = npc_from + (npc_to - npc_from) * Ease.SineInOut(t)
    particle.Position = particle_from + (particle_to - particle_from) * Ease.SineInOut(t)
    wait()
  end
  -- back up
  
  say("RotationCollab_Lobby_Baddy_C")
  
  npc_from = npc.Position
  npc_to = vector2(npc.Position.X + 550, npc.Position.Y - 0)
  
  particle_from = particle.Position
  particle_to = vector2(particle.Position.X + 550, particle.Position.Y - 0)
  --reset the pos again
  
  local plat = getEntity("JumpThru")
  -- this get entity also gets the jungle helper invis jumpthrotgh
  local plat_from = plat.Position
  local plat_to = vector2(plat.Position.X - 25, plat.Position.Y - 0)
  player.Sprite.Play(player.Sprite, "wakeUp")
  wait(0.1)
  player.DummyAutoAnimate = true
  playSound("event:/char/badeline/level_entry")
  num_seconds = 1
  setFlag("Ladder_Real", true)
  --reveal ladder (real)
  for t = 0, num_seconds, Engine.DeltaTime do
    npc.Position = npc_from + (npc_to - npc_from) * Ease.SineInOut(t)
    particle.Position = particle_from + (particle_to - particle_from) * Ease.SineInOut(t)
	plat.Position = plat_from + (plat_to - plat_from) * Ease.SineInOut(t)
    wait()
  end
  wait(0.1)
  dashUp()
  --dash up, duh
  miniTextbox ("RotationCollab_Lobby_Baddy_E")
  plat_to = vector2(plat.Position.X + 25, plat.Position.Y - 0)
  for t = 0, num_seconds, Engine.DeltaTime do
	plat.Position = plat_from + (plat_to - plat_from) * Ease.SineInOut(t)
    wait()
  end
  wait(0.2)
  walk(25)
  player.DummyAutoAnimate = false
  player.Sprite.Play(player.Sprite, "sitDown")
  wait(0.4)
  playSound("event:/game/03_resort/door_wood_close")
  setFlag("Ladder_Real", false)
  --close the hatch
  say("RotationCollab_Lobby_Baddy_D")
  --end
  
  
  wait(0.4)
  --teleportTo(198, -193, "Lobby-H2eart-Hallway2", "None")
  
  
  endCutscene()
end

--- Callback for when the cutscene ends.
-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
-- @tparam #Celeste.Level room Current room.
-- @bool wasSkipped If the cutscene was skipped.
function onEnd(room, wasSkipped)
  setFlag("MusicBaddyA", true)
  player.DummyAutoAnimate = true
  player.StateMachine.Locked = false
  enableMovement()
  enableRetry()
  if wasSkipped then
	teleportTo(198, -193, "Lobby_H2eart_Hallway2", "None")
  else
	teleportTo(198, -193, "Lobby_H2eart_Hallway2", "None")
  end
end

--- Callback for when a player enters the trigger.
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that entered the trigger.
function onEnter(player)
  wasDashAssistOn = celeste.SaveData.Instance.Assists.DashAssist
end

function dashUp()
    celeste.SaveData.Instance.Assists.DashAssist = false
    celeste.Input.Rumble(celeste.RumbleStrength.Strong, celeste.RumbleLength.Medium)
    minput.Disabled = true
    player.OverrideDashDirection = vector2(0, -1)
    player.StateMachine.Locked = false
    player.StateMachine.State = player:StartDash()
    player.Dashes = 0
    wait(0.1)
    while (player.Speed.Y < 0) do -- Waits till maddy stops moving up
        player.Dashes = 0
        celeste.Input.MoveY.Value = -1
        celeste.Input.MoveX.Value = 0
        wait()
    end
    player.OverrideDashDirection = nil
    player.StateMachine.State = 11
    player.StateMachine.Locked = true
    minput.Disabled = false
end

--- Callback for when a player stays in the trigger (once per frame).
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that is staying in the trigger.
function onStay(player)
  engine.Scene:DirectionalShake({ x = 100, y = 100 }, 0.02)
end

--- Callback for when a player leaves the trigger.
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that exited the trigger.
function onLeave(player)
  enableMovement()
  enableRetry()
end
