--- Coroutine that is called when the cutscene starts.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
function onTalk()
end

local Engine = require("#monocle.engine")
local Calc = require("#monocle.calc")
local Ease = require("#monocle.ease")
local minput = require("#Monocle.MInput")
local wasDashAssistOn = false

local celeste = require("#celeste")
local Audio = require("#Celeste.Audio")
local Buses = require("#Celeste.Buses")
local DynamicData = require("#MonoMod.Utils").DynamicData
local EntityID = celeste.EntityID

local function muteMusic(mute)
  Audio.BusPaused(Buses.MUSIC, mute);
end

local DropWipe = require("#celeste.SpotlightWipe")
local fade = nil

function onBegin()
  local called_before = getFlag("NOMORECARnomoreluaA")
  
  if not called_before then
	muteMusic(false)
	setFlag("Ladder_RealB1", false)
	disableRetry()
	disableMovement()
	waitUntilOnGround()
	player.ForceCameraUpdate = true;
	walkTo(2401)
	wait(0.3)
	local npc = getEntity("MoreCustomNPC", "Celeste.Mod.MaxHelpingHand.Entities.")
	local npc_from = npc.Position
	local npc_to = vector2(npc.Position.X + 0, npc.Position.Y + 210)
	playSound("event:/game/03_resort/deskbell_again", player.Position)
	local num_seconds = 4
	for t = 0, num_seconds, Engine.DeltaTime do
		npc.Position = npc_from + (npc_to - npc_from) * Ease.SineOut(t/num_seconds)
		wait()
	end
	wait(0.3)
	say("RotationCollab_Lobby_KrisGetInTheCarA")
	wait(0.3)
	playSound("event:/game/00_prologue/car_down", player.Position)
	muteMusic(true)
	setFlag("Ladder_RealB1", true)
	wait(0.1)
	playSound("event:/game/00_prologue/car_up", player.Position)
	wait(2)
	
	
    fade = DropWipe(getRoom(), false)
    fade.Duration = 1.9
    fade.EndTimer = 1.0
	DropWipe.FocusPoint = vector2(215,151)
    coroutine.yield(fade:Wait());

    enableMovement()
	log("PassA", "RC")
	setFlag("Ladder_RealB1", false)
	log("PassB", "RC")
	--cutsceneEntity:RemoveSelf()
	setFlag("NOMORECARnomoreluaA", true)
	log("PassC", "RC")
	--entityid = EntityID("Lobby-SideB", 913) -- 913 is entity id in loenn
	--getRoom().Session.DoNotLoad:Add(entityid)
	--cutsceneEntity:RemoveSelf()
	muteMusic(false)
	log("PassD", "RC")
	DropWipe.FocusPoint = vector2(160,90)
	teleportTo(105, -197, "Lobby-Heart-Hallway", "Transition")
	log("PassE", "RC")

    fade = DropWipe(getRoom(), true)
    fade.Duration = 1.9
    fade.EndTimer = 1.0
	--fade.focusPoint = player.Position
    coroutine.yield(fade:Wait())
	
	
	--wait(0.13)
  end
  endCutscene()
end

--- Callback for when the cutscene ends.
-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
-- @tparam #Celeste.Level room Current room.
-- @bool wasSkipped If the cutscene was skipped.
function onEnd(room, wasSkipped)
  enableMovement()
  enableRetry()
  local called_before = getFlag("NOMORECARnomoreluaA")
  if not called_before then
	log("PassAend", "RC")
	setFlag("Ladder_RealB1", false)
	--log("PassB", "RC")
	--cutsceneEntity:RemoveSelf()
	setFlag("NOMORECARnomoreluaA", true)
	--log("PassC", "RC")
	--entityid = EntityID("Lobby-SideB", 913) -- 913 is entity id in loenn
	--getRoom().Session.DoNotLoad:Add(entityid)
	--cutsceneEntity:RemoveSelf()
	muteMusic(false)
	--log("PassD", "RC")
	--teleportTo(105, -197, "Lobby-Heart-Hallway", "None")
	--log("PassE", "RC")
  end
  --log("PassF", "RC")
end