--- Coroutine that is called when the cutscene starts.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
function onTalk()
end

function onBegin()
  disableRetry()
  disableMovement()
  say("RotationCollab_Lobby_E")
  wait(0.4)
  say("RotationCollab_Lobby_F")
  wait(0.2)
  setFlag("CONFETTIDIE", true)
  jump(2.0)
  walk(-55)
  wait(0.6)
  endCutscene()
end

--- Callback for when the cutscene ends.
-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
-- @tparam #Celeste.Level room Current room.
-- @bool wasSkipped If the cutscene was skipped.
function onEnd(room, wasSkipped)
  setFlag("CONFETTIDIE", false)
  enableMovement()
  enableRetry()
end

--- Callback for when a player enters the trigger.
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that entered the trigger.
function onEnter(player)
end

--- Callback for when a player stays in the trigger (once per frame).
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that is staying in the trigger.
function onStay(player)
end

--- Callback for when a player leaves the trigger.
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that exited the trigger.
function onLeave(player)
  enableMovement()
end
