--- Coroutine that is called when the cutscene starts.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
function onTalk()
end

function onBegin()
  --wait(2.5)
  disableMovement()
  player.DummyAutoAnimate = false
  player.Sprite.Play(player.Sprite, "sitDown")
  player.Sprite:SetAnimationFrame(player.Sprite.CurrentAnimationTotalFrames - 1)
  wait(2.5)
  --setPlayerState(17)
  say("RotationCollab_Lobby_A")
  wait(0.6)
  say("RotationCollab_Lobby_B")
  wait(0.9)
  say("RotationCollab_Lobby_C")
  wait(0.2)
  player.DummyAutoAnimate = true
  endCutscene()
end

--- Callback for when the cutscene ends.
-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
-- @tparam #Celeste.Level room Current room.
-- @bool wasSkipped If the cutscene was skipped.
function onEnd(room, wasSkipped)
  enableMovement()
  teleportTo(17, 14, "Start_Room", "None")
end

--- Callback for when a player enters the trigger.
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that entered the trigger.
function onEnter(player)
end

--- Callback for when a player stays in the trigger (once per frame).
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that is staying in the trigger.
function onStay(player)
  --engine.Scene:DirectionalShake(vector2(0, 0), 0.5)
  --DynamicData.For(engine.Scene):Set("shakeDirection", vector2(500, 500))
  --engine.Scene.shakeDirection = vector2(19990.1, 19990.1)
  --shake({ x = 100, y = 100 },0.016)
  --to anyone who reads this i am trapped here, can you explain why the duration "0.02" affects the magnitude
  engine.Scene:DirectionalShake({ x = 100, y = 100 }, 0.02)
end

--- Callback for when a player leaves the trigger.
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that exited the trigger.
function onLeave(player)
  enableMovement()
end
