local fullDashController = {}

fullDashController.name = "ManganeeseHelper/FullDashController/ActivateFlag"
fullDashController.depth = -100
fullDashController.placements = {
    name = "normal",
    data = {
	angles = "",
	error = 0.1,
	angleUnit = "Degrees",
	flag = "flag1"
    },
}
fullDashController.fieldInformation = {
    angles = {
	fieldType = "string",
    },
    error = {
	fieldType = "number",
	minimumValue = 0.0,
    },
    angleUnit = {
	fieldType = "string",
	options = {
	    Degrees = "Degrees",
	    Radians = "Radians",
	},
	editable = false,
    },
    flag = {
	fieldType = "string",
    }
}

function fullDashController.fieldInformation.angles.validator(input)
    for str in string.gmatch(input, "([^,]+)") do
	local t = {}
	for val in string.gmatch(str, "([^;]+)") do
	    table.insert(t, val)
	end
	if t[0] ~= nil and t[0].len() > 1 and tonumber(t[0]) == nil then
	    return false
	end
    end
    return true
end
return fullDashController
