﻿using Celeste.Mod;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Celeste;
using Monocle;
using Microsoft.Xna.Framework;
using MonoMod;
using MonoMod.Cil;
using MonoMod.Utils;
using MonoMod.RuntimeDetour;

namespace Celeste.Mod.xoliMWC
{
    public class xolimwc : EverestModule
    {
        public static xolimwc Instance;

        public xolimwc() { Instance = this; }

        public override Type SessionType => typeof(mwcSession);
        public static mwcSession Session => (mwcSession)Instance._Session;

        public static Player GetPlayer()
        {
            return (Engine.Scene as Level)?.Tracker?.GetEntity<Player>();
        }

        public static bool TryGetPlayer(out Player player)
        {
            player = GetPlayer();
            return player != null;
        }

        // Set up any hooks, event handlers and your mod in general here.
        // Load runs before Celeste itself has initialized properly.
        public override void Load()
        {
            On.Celeste.PlayerHair.GetHairColor += DashHairColor;
            On.Celeste.Player.Update += Player_Update;
            IL.Celeste.Player.Render += Player_Render;
        }

        private void Player_Render(ILContext il)
        {
            ILCursor cursor = new ILCursor(il);
            if (cursor.TryGotoNext(MoveType.Before, i => i.MatchBrfalse(out ILLabel _) && i.Previous.MatchCallvirt<Player>("get_IsTired")))
            {
                cursor.EmitDelegate<Func<bool, bool>>(b => b || Session.gasTimer > 2f);
            }
        }

        private void Player_Update(On.Celeste.Player.orig_Update orig, Player self)
        {
            orig(self);
            if(Session.prevGasTimer < 0.5f && Session.gasTimer >= 0.5f)
            {
                Audio.Play("event:/xoli_mwc/gas");
            }
            else if(Session.prevGasTimer < 1.5f && Session.gasTimer >= 1.5f)
            {
                Audio.Play("event:/xoli_mwc/gas2");
            }
            else if (Session.prevGasTimer < 2.5f && Session.gasTimer >= 2.5f)
            {
                Audio.Play("event:/xoli_mwc/gas3");
            }
            if (Session.gasTimer >= 3f) self.Die(Vector2.Zero);
            Session.prevGasTimer = Session.gasTimer;
        }

        public Color DashHairColor(On.Celeste.PlayerHair.orig_GetHairColor orig, PlayerHair self, int index)
        {
            if (Session.gasTimer > 0f)
            {

                return Color.Lerp(orig.Invoke(self, index), Color.White, Session.gasTimer / 3f);
            }
            return orig.Invoke(self, index);
        }

        // Unload the entirety of your mod's content. Free up any native resources.
        public override void Unload()
        {
            On.Celeste.PlayerHair.GetHairColor -= DashHairColor;
            On.Celeste.Player.Update -= Player_Update;
            IL.Celeste.Player.Render -= Player_Render;
        }

    }

    public class mwcSession : EverestModuleSession
    {
        public float prevGasTimer { get; set; } = 0;
        public float gasTimer { get; set; } = 0;
        public bool gas1 { get; set; } = false;
        public bool gas2 { get; set; } = false;
        public bool gas3 { get; set; } = false;
    }
}
