﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;
using Monocle;

namespace Celeste.Mod.xoliMWC
{
    [CustomEntity("xoliMWC/PoisonGas")]
    [Tracked]
    public class PoisonGas : Entity
    {
        private Circle c;
        public float r;
        private Image i;
        private Vector2 anchor;
        private SineWave sine;

        public PoisonGas(Vector2 position, string spriteDirectory, int scale) : base(position)
        {
            c = new Circle(48, position.X, position.Y);
            Collider = c;
            r = 48;
            Add(i = new Image(GFX.Game[spriteDirectory]));
            Add(sine = new SineWave(0.33f, 0f).Randomize());
            i.Scale.X = i.Scale.Y = scale;
            i.CenterOrigin();
            Depth = -101;
            anchor = position;

        }
        public PoisonGas(EntityData data, Vector2 offset)
            : this(data.Position + offset, data.Attr("spriteDirectory", defaultValue: "objects/24_circle"), data.Int("scale", defaultValue: 2))
        {
        }
        private bool kill = false;
        public override void Update()
        {
            kill = true;
            base.Update();
            if (xolimwc.TryGetPlayer(out Player p))
            {
                if (Vector2.Distance(p.Center, Position) <= r)
                {
                    p.Sprite.Color = Color.Green;
                    xolimwc.Session.gasTimer += Engine.DeltaTime * Engine.TimeRate;
                }
                else if ((this.Scene as Level) != null)
                {
                    foreach (PoisonGas g in (this.Scene as Level).Tracker.GetEntities<PoisonGas>())
                    {
                        if (Vector2.Distance(p.Center, g.Position) <= g.r)
                        {
                            kill = false;
                        }
                    }
                    xolimwc.Session.gasTimer = (kill ? 0f : xolimwc.Session.gasTimer);
                }
            }
            Position = anchor + new Vector2(sine.Value * 3f, sine.ValueOverTwo * 2f);
        }

        public override void DebugRender(Camera camera)
        {
            base.DebugRender(camera);
            Draw.Circle(Position, r, Color.Green, 80);
        }
    }
}

