module xoliMWCPoisonGas

using ..Ahorn, Maple

@mapdef Entity "xoliMWC/PoisonGas" SusanPoison(x::Integer, y::Integer, spriteDirectory::String="objects/24_circle", scale::Integer=2)


const placements = Ahorn.PlacementDict(
   "Poison Gas (Susan Helper)" => Ahorn.EntityPlacement(
	  SusanPoison,
	  "point"
   )
)

sprite = "objects/boostVoid/booster00"

function Ahorn.selection(entity::SusanPoison)
    x, y = Ahorn.position(entity)
    return Ahorn.getSpriteRectangle(sprite, x, y)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::SusanPoison, room::Maple.Room) = Ahorn.drawSprite(ctx, sprite, 0, 0)

end

