﻿//                                                                                          //
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>//
//                                                                                          //
//                                                                                          //
//                You can copy and paste this file directly into your mod.                  //
//            You only need to change the namespace Celeste.Mod.KelperApiExample            //
//                          to match your own mod's namespace and                           //
//                 add KelperImports.Load() into your module's Load function                //
//                                                                                          //
//                                                                                          //
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<//
//                                                                                          //
using Microsoft.Xna.Framework;
using MonoMod.ModInterop;
using Monocle;
using System;
using System.Diagnostics.CodeAnalysis;
#pragma warning disable CS0618 // Type or member is obsolete

namespace Celeste.Mod.KelperApiExample;

[ModImportName("KelperAPI")]
[SuppressMessage("ReSharper", "UnassignedField.Global")]
public static class KelperImports
{
    /// <summary>
    ///     If there is some massive change that breaks the modinterop this version number will change.  <br/>
    ///     It should never happen hopefully.
    /// </summary>
    public static int? GetVersion()
        => GetVersionDelegate?.Invoke();

    
    /// <summary>
    ///     Returns a KelperNailCollider as a Component.                                                <br/>
    ///     For example the following collider calls the following method:
    /// </summary>
    /// <code>
    ///     Add(CreateNailCollider(OnNailHit, [10, "something", new Vector2(1, 20)]));
    ///     public static void OnNailHit(Player player, Vector2 nailDir, int number, string text, Vector2 vector) { }
    /// </code>
    /// <param name="callback">A callback function that gets run when the entity is hit with the nail.</param>
    /// <param name="parameters">Parameters for the method. The first two parameters on the callback function are always <c>Player player</c> and <c>Vector2 nailDir</c>.
    /// Even if they are not specified anywhere.</param>
/// <returns>The component or null if Kelper is not enabled.</returns>
    public static Component CreateNailCollider(Delegate callback, object[] parameters = null)
        => CreateNailColliderDelegate?.Invoke(callback, parameters);


    /// <summary>
    ///     Returns a KelperNailCollider as a Component with a custom hitbox that interacts with the nail.
    /// </summary>
    /// <code>
    ///     Add(CreateNailCollider(new Hitbox(1,2,3,4), OnNailHit, [10, "something"]));
    ///     public static void OnNailHit(Player player, Vector2 nailDir, int num, string text) { }
    /// </code>
    /// <param name="hitbox">The custom hitbox that interacts with the nail.</param>
    /// <param name="callback">A callback function that gets run when the entity is hit with the nail.</param>
    /// <param name="parameters">Parameters for the method. The first two parameters on the callback function are always <c>Player player</c> and <c>Vector2 nailDir</c>.
    /// Even if they are not specified anywhere.</param>
    /// <returns>The component or null if Kelper is not enabled.</returns>
    public static Component CreateNailColliderWithCustomHitbox(Hitbox hitbox, Delegate callback, object[] parameters = null)
        => CreateNailColliderWithCustomHitboxDelegate?.Invoke(callback, hitbox, parameters);

    /// <summary>
    /// Returns a nailDir that is flipped vertically if the player has upside down gravity. <br/>
    /// Vector2(0, 1) means that the player is swinging towards their feet.
    /// </summary>
    /// <returns>Vector2 or null if Kelper is not enabled.</returns>>
    public static Vector2? GetGravityRelativeNailDir()
        => GetGravityRelativeNailDirDelegate?.Invoke();
    

    /// <summary>
    ///     Bounces the player backwards relative to the nail swing direction. <br/>
    ///     If multiple entities are hit on the same frame, the highest multiplier will be applied.
    ///     Has logic to handle adding speed and backboosting etc.
    /// </summary>
    /// <param name="multiplier">Rebound strength multiplier. Minimum value is 1f</param>
    public static void ApplyNailRebound(float multiplier = 1f)
        => ApplyNailReboundDelegate?.Invoke(multiplier);

    
    /// <summary>
    ///     Plays a kind of metallic tink sound
    /// </summary>
    public static void PlayNailTinkSound()
        => PlayNailTinkSoundDelegate?.Invoke();

    
    /// <summary>
    /// Disables the nail hitbox for the current swing. All entities hit on this frame will still be hit.
    /// </summary>
    public static void ConsumeNailSwing()
        => ConsumeNailSwingDelegate?.Invoke();

    
    
    /// <summary>
    ///     Creates a HitCounter and returns it as a Component.
    /// </summary>
    /// <code>
    ///     Add(CreateHitCounter(3, -10, true, Color.Purple, ReachedZero, [10, "something", new Vector2(1, 20)]));
    ///     public void ReachedZero(int num, string text, Vector2 vector) { }
    /// </code>
    /// <param name="count">The amount of nail hits.</param>
    /// <param name="displayOffset">How high the count display should be.</param>
    /// <param name="disableKNCWhen0">Automatically removes kelper nail colliders from the entity.</param>
    /// <param name="color">The color of the count display.</param>
    /// <param name="callBack">A method that gets run when the counter reaches 0.</param>
    /// <param name="parameters">Parameters for the callBack.</param>
    /// <returns>The component or null if Kelper is not enabled.</returns>
    public static Component CreateHitCounter(int count, int displayOffset, bool disableKNCWhen0, Color color, Delegate callBack = null, object[] parameters = null) 
        => CreateHitCounterDelegate?.Invoke(count, displayOffset, disableKNCWhen0, color, callBack, parameters);
    
    
    
    
    
    // Delegates used by the ModInterop.
    [Obsolete("Use the provided method instead of the delegate.")]
    public static Func<int, int, bool, Color, Delegate, object[], Component> CreateHitCounterDelegate;
    [Obsolete("Use the provided method instead of the delegate.")]
    public static Action ConsumeNailSwingDelegate;
    [Obsolete("Use the provided method instead of the delegate.")]
    public static Action PlayNailTinkSoundDelegate;
    [Obsolete("Use the provided method instead of the delegate.")]
    public static Action<float> ApplyNailReboundDelegate;
    [Obsolete("Use the provided method instead of the delegate.")]
    public static Func<Vector2> GetGravityRelativeNailDirDelegate;
    [Obsolete("Use the provided method instead of the delegate.")]
    public static Func<Delegate, Hitbox, object[], Component> CreateNailColliderWithCustomHitboxDelegate;
    [Obsolete("Use the provided method instead of the delegate.")]
    public static Func<Delegate, object[], Component> CreateNailColliderDelegate;
    [Obsolete("Use the provided method instead of the delegate.")]
    public static Func<int> GetVersionDelegate;
    
    public static void Load()
    {
        typeof(KelperImports).ModInterop();
    }
    
}

