﻿using System;

namespace Celeste.Mod.KelperApiExample;

public class KelperApiExampleModule : EverestModule {
    public static KelperApiExampleModule Instance { get; private set; }

    public KelperApiExampleModule() {
        Instance = this;
#if DEBUG
        // debug builds use verbose logging
        Logger.SetLogLevel(nameof(KelperApiExampleModule), LogLevel.Verbose);
#else
        // release builds use info logging to reduce spam in log files
        Logger.SetLogLevel(nameof(KelperApiExampleModule), LogLevel.Info);
#endif
    }

    public override void Load() {
        KelperImports.Load();
    }

    public override void Unload() {
    }
}