﻿using static Celeste.Mod.KelperApiExample.KelperImports;
using Microsoft.Xna.Framework;
using Monocle;
using System;
using Celeste.Mod.Entities;

namespace Celeste.Mod.KelperApiExample.Entities;

[CustomEntity("KelperApiExample/Ball")]
public class NailCompatibleBall : Actor
{
    public Sprite sprite;
    public Vector2 Speed;
    public Component counter;
    
    public NailCompatibleBall(EntityData data, Vector2 offset)
        : base(data.Position + offset)
    {
        Depth = 100;
        Collider = new Hitbox(8f, 10f, -4f, -10f);
        Tag = Tags.TransitionUpdate;
        
        Add(new VertexLight(Collider.Center, Color.White, 1f, 32, 64));
        Add(sprite = GFX.SpriteBank.Create("badelineBoost"));
        sprite.Position.Y -= 6;
        
        float knockbackStrength = 300f;
        Hitbox nailHitbox = new Hitbox(10f, 10f, -5f, -10f);
        object[] parameters = new object[] { this, knockbackStrength };

        // You can also write the parameters directly with collection expressions
        // Component nailCollider = CreateNailColliderWithCustomHitbox(nailHitbox, OnNailHit, [this, knockbackStrength]));
        Component nailCollider = CreateNailColliderWithCustomHitbox(nailHitbox, OnNailHit, parameters);
        if (nailCollider != null) Add(nailCollider);

        counter = CreateHitCounter(3, -21, false, Color.Purple, CountReachedZero, []);
        if(counter != null) Add(counter);
    }
    
    // The player entity and the absolute nail direction are always the first 2 parameters.
    // They are followed by the user defined parameters.
    private bool OnNailHit(Player player, Vector2 nailDir, NailCompatibleBall self, float knockbackStrength)
    {
        // The parameter nailDir is normally relative to the screen. Upswing is always Vector2(0, -1). 
        // Here we get a nailDir that is relative to the players gravitational orientation.

        // If the nailDir is down, (up when GravityHelper has flipped gravity), we call the NailRebound method.
        if (GetGravityRelativeNailDir()?.Y > 0)
            // Uses kelpers nailrebound method to knock the player back.
            ApplyNailRebound(1.3f);

        // Plays a tink sound on the player's position.
        PlayNailTinkSound();

        // Removes the nail hitbox for the current swing.
        ConsumeNailSwing();
        
        self.Speed = nailDir * knockbackStrength;

        // Hit is successful: return true.
        return true;
    }


    public void CountReachedZero()
    {
        counter.RemoveSelf();
        sprite.Color = sprite.Color == Color.White ? Color.DarkSlateGray : Color.White;
        Color counterColor = sprite.Color == Color.White ? Color.Purple : Calc.HexToColor("1f193f");
        Add(counter = CreateHitCounter(3, -21, false, counterColor, CountReachedZero, []));
    }
    
    
    
    // Just some movement logig ripped from TheoCrystal.
    // Not a part of this example, just something to make the entity do something slightly interesting.
    public override void Update()
    {
        base.Update();

        if (OnGround())
        {
            float target = ((!OnGround(Position + Vector2.UnitX * 3f)) ? 20f : (OnGround(Position - Vector2.UnitX * 3f) ? 0f : (-20f)));
            Speed.X = Calc.Approach(Speed.X, target, 800f * Engine.DeltaTime);
        }
        else
        {
            float num = 800f;
            if (Math.Abs(Speed.Y) <= 30f)
            {
                num *= 0.5f;
            }

            float num2 = 350f;
            if (Speed.Y < 0f)
            {
                num2 *= 0.5f;
            }

            Speed.X = Calc.Approach(Speed.X, 0f, num2 * Engine.DeltaTime);
            Speed.Y = Calc.Approach(Speed.Y, 200f, num * Engine.DeltaTime);
        }

        MoveH(Speed.X * Engine.DeltaTime);
        MoveV(Speed.Y * Engine.DeltaTime);
    }

}

