﻿using static Celeste.Mod.KelperApiExample.KelperImports;
using Microsoft.Xna.Framework;
using Monocle;
using System;
using Celeste.Mod.Entities;
using System.Xml.Schema;

namespace Celeste.Mod.KelperApiExample.Entities;

[CustomEntity("KelperApiExample/CustomBooster")]
public class CustomBooster : Booster
{
    public Vector2 Speed;

    public CustomBooster(EntityData data, Vector2 offset)
        : base(data.Position + offset, false)
    { }

    public override void Added(Scene scene)
    {
        // Kelper already adds a nail collider into some vanilla entities, for example boosters, which this entity inherits.
        // Kelper's own nail colliders get added in the base.Added method.
        // If you add your collider before calling base.Added the base entity will notice this and will not add kelper's default nail collider.
        // If you add your collider after calling base.Added, the entity will have both nail colliders. This can be useful as demonstrated here.
        base.Added(scene);
        Component nailCollider = CreateNailCollider(OnNailHit, [this]);
        if (nailCollider != null) Add(nailCollider);
    }

    // This is the method that gets run when the entity gets hit with the nail.
    // It should return a bool representing whether the hit was successful or not.
    private bool OnNailHit(Player player, Vector2 nailDir, CustomBooster self)
    {
        //Invoking any of the nail methods here isn't necessary since they already get ran in the base class.
        //This is here in case you want to try moving the base.Added(scene) on line 25 to happen after adding the nail collider.
        ConsumeNailSwing();

        if (self.respawnTimer > 0 || player.CurrentBooster == self)
        { // Hit isn't successful: return false.
            return false;
        }

        self.red = !self.red;
        self.sprite.RemoveSelf();
        self.Add(self.sprite = GFX.SpriteBank.Create(self.red ? "boosterRed" : "booster"));
        self.sprite.Play("loop", restart: true);
        Audio.Play(self.red ? "event:/game/05_mirror_temple/redbooster_reappear" : "event:/game/04_cliffside/greenbooster_reappear", self.Position);
        self.particleType = (self.red ? P_BurstRed : P_Burst);
        self.AppearParticles();
        self.wiggler.Start();
        Logger.Warn("KelperApiExample", "Custom collider hit!");

        // Hit is successful: return true.
        return true;
    }
}

