local rectangles = require("structs.rectangle")

local playerChain = {}

playerChain.name = "MoladanHelper/PlayerChain"
playerChain.depth = -2000
playerChain.canResize = {false, false}
playerChain.placements = {
    name = "playerChain",
    data = {
        radius = 32,
        color = "2f4f4f",
        pullStrength = 0.5,
        criticalForceForGrab = 50.0,
        criticalForceToBreak = 40.0,
    }
}
playerChain.fieldInformation = {
    color = {
        fieldType = "color"
    }
}

function playerChain.selection(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local radius = entity.radius * 2
    return rectangles.getPoints(x, y, radius, radius)
end

function playerChain.draw(room, entity, viewport)
    local x, y = entity.x or 0, entity.y or 0
    love.graphics.circle("line", x, y, entity.radius)
end

return playerChain