local drawableSprite = require("structs.drawable_sprite")
local utils = require("utils")

local fancyTheoCrystal = {}

fancyTheoCrystal.name = "FrenchHelper/FancyTheoCrystal"
fancyTheoCrystal.depth = 0
fancyTheoCrystal.placements = {
	name = "Fancy Theo Crystal",
	data = {
		crystalColor = "blue"
	}
}

fancyTheoCrystal.fieldInformation = {
	crystalColor = {
		options = {
			["Blue"] = "blue",
			["Yellow"] = "yellow",
			["Pink"] = "pink",
			["Purple"] = "purple"
		},
		editable = false
	}
}

function fancyTheoCrystal.sprite(room, entity)

	local textureRaw = entity.crystalColor ~= "" and entity.crystalColor or "blue"
    local texture = "objects/FrenchHelper/FancyTheoCrystal/" .. textureRaw

	local sprite = drawableSprite.fromTexture(texture, entity)

	return sprite
end

function fancyTheoCrystal.selection(room, entity)
    return utils.rectangle(entity.x - 10 or 0, entity.y - 10 or 0, 20, 20)
end

return fancyTheoCrystal
