local drawableSprite = require("structs.drawable_sprite")
local utils = require("utils")

local strongJelly = {}

strongJelly.name = "FrenchHelper/StrongJelly"
strongJelly.depth = 0
strongJelly.placements =  {
	name = "Strong Jelly",
	data = {
		jellyColor = "objects/glider",
		barrierBehavior = "AllThrough",
		bubble = false,
		customColor = true
	}
}

strongJelly.fieldInformation = {
	jellyColor = {
		options = {
			["Default"] = "objects/glider",
			["Deep blue"] = "objects/FrenchHelper/StrongJelly/deep_blue",
			["Green"] = "objects/FrenchHelper/StrongJelly/green",
			["Grey"] = "objects/FrenchHelper/StrongJelly/grey",
			["Orange"] = "objects/FrenchHelper/StrongJelly/orange",
			["Pink"] = "objects/FrenchHelper/StrongJelly/pink",
			["Purple"] = "objects/FrenchHelper/StrongJelly/purple",
			["Red"] = "objects/FrenchHelper/StrongJelly/red",
			["Yellow"] = "objects/FrenchHelper/StrongJelly/yellow"
		},
		editable = false
	},
	barrierBehavior = {
		options = {"AllThrough", "ColorCoded", "ColorCollide", "Vanilla"},
		editable = false
	}
}

function strongJelly.sprite(room, entity)

	local textureRaw = entity.jellyColor ~= "" and entity.jellyColor or "objects/glider"
	
	if(textureRaw == "objects/glider")
	then
		texture = textureRaw .. "/idle0"
	else
		texture = textureRaw .. "/idle0"
	end
	
	local sprite = drawableSprite.fromTexture(texture, entity)

	return sprite
end

function strongJelly.selection(room, entity)
    return utils.rectangle(entity.x - 12 or 0, entity.y - 14 or 0, 26, 17)
end

return strongJelly
