local drawableSprite = require("structs.drawable_sprite")
local utils = require("utils")

local starLight = {}

starLight.name = "FrenchHelper/StarLight"
starLight.depth = 0
starLight.placements =  {
	name = "Star Light"
}

function starLight.sprite(room, entity)

	local textureRaw = entity.starLight ~= "" and entity.starLight or "objects/FrenchHelper/StarLight"
	
	if(textureRaw == "objects/FrenchHelper/StarLight")
	then
		texture = textureRaw .. "/idle0"
	else
		texture = textureRaw .. "/idle0"
	end
	
	local sprite = drawableSprite.fromTexture(texture, entity)

	return sprite
end

function starLight.selection(room, entity)
    return utils.rectangle(entity.x - 4 or 0, entity.y - 4 or 0, 8, 8)
end

return starLight
