local drawableSprite = require("structs.drawable_sprite")
local drawableNinePatch = require("structs.drawable_nine_patch")
local drawableRectangle = require("structs.drawable_rectangle")

local ReskinnableMoveBlock = {}

ReskinnableMoveBlock.name = "FrenchHelper/ReskinnableMoveBlock"
ReskinnableMoveBlock.depth = 8995
ReskinnableMoveBlock.minimumSize = {16, 16}

local ReskinnableMoveBlockDirections = {
    "Up", "Right", "Down", "Left"
}

ReskinnableMoveBlock.fieldInformation = {
    color = {
        options = {
			["Default"] = "default",
			["Red"] = "red",
			["White"] = "white"
		},
		editable = false
    },
	direction = {
        options = ReskinnableMoveBlockDirections,
        editable = false
    }
}

ReskinnableMoveBlock.placements = {
	{
		name = "Reskinnable MoveBlock",
		data = {
			width = 16,
			height = 16,
			color = "default",
			direction = "Right",
			buttonsColor = "",
			arrowColor = "",
			idleBackground = "474070",
			breakingBackground = "CC2541",
			canSteer = false,
		}
	}
}

ReskinnableMoveBlock.fieldOrder = {
	"x", "y", "width", "height",
	"idleBackground", "breakingBackground",
	"arrowColor", "buttonsColor",
	"color", "direction",
	"canSteer"
}

local ninePatchOptions = {
    mode = "border",
    borderMode = "repeat"
}

local buttonNinePatchOptions = {
    mode = "fill",
    border = 0
}

local midColor = {4 / 255, 3 / 255, 23 / 255}
local highlightColor = {59 / 255, 50 / 255, 101 / 255}
local buttonColor = {71 / 255, 64 / 255, 112 / 255}

local frameTexture = "/base"
local arrowTextures = {
    up = "/arrow02",
    upright = "/arrow01",
    right = "/arrow00",
    downright = "/arrow07",
    down = "/arrow06",
    downleft = "/arrow05",
    left = "/arrow04",
    upleft = "/arrow03",
    unknown = "/unknown"
}

local colorToHexa = {
	default = {4 / 255, 3 / 255, 23 / 255},
	red = {208 / 255, 0 / 255, 0 / 255},
	white = {200 / 255, 201 / 255, 201 / 255}
}

function ReskinnableMoveBlock.sprite(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local width, height = entity.width or 24, entity.height or 24

    local direction = string.lower(entity.direction or "up")
	local color = entity.color or "default"
    local spritePath = entity.spritePath or "objects/FrenchHelper/ReskinnableMoveBlock/" ..  color

    local blockTexture = spritePath .. frameTexture
    local arrowTexture = spritePath .. (arrowTextures[direction] or arrowTextures["up"])

    local ninePatch = drawableNinePatch.fromTexture(blockTexture, ninePatchOptions, x, y, width, height)

    local highlightRectangle = drawableRectangle.fromRectangle("fill", x + 2, y + 2, width - 4, height - 4, highlightColor)
    local midRectangle = drawableRectangle.fromRectangle("fill", x + 8, y + 8, width - 16, height - 16, colorToHexa[color])

    local arrowSprite = drawableSprite.fromTexture(arrowTexture, entity)
    local arrowSpriteWidth, arrowSpriteHeight = arrowSprite.meta.width, arrowSprite.meta.height
    local arrowX, arrowY = x + math.floor((width - arrowSpriteWidth) / 2), y + math.floor((height - arrowSpriteHeight) / 2)
    local arrowRectangle = drawableRectangle.fromRectangle("fill", arrowX, arrowY, arrowSpriteWidth, arrowSpriteHeight, highlightColor)

    arrowSprite:addPosition(math.floor(width / 2), math.floor(height / 2))

    local sprites = {}

    table.insert(sprites, highlightRectangle:getDrawableSprite())
    table.insert(sprites, midRectangle:getDrawableSprite())

    for _, sprite in ipairs(ninePatch:getDrawableSprite()) do
        table.insert(sprites, sprite)
    end

    table.insert(sprites, arrowRectangle:getDrawableSprite())
    table.insert(sprites, arrowSprite)

    return sprites
end



return ReskinnableMoveBlock
