local drawableSprite = require("structs.drawable_sprite")
local drawableNinePatch = require("structs.drawable_nine_patch")

local jellyBlock = {}

jellyBlock.name = "FrenchHelper/JellyBlock"
jellyBlock.depth = 0
jellyBlock.placements = {
    name = "Jelly Block",
    data = {
        width = 8,
        height = 8,
        color = "normal"
    }
}

jellyBlock.fieldInformation = {
    color = {
        options = {
			["Default"] = "normal",
			["Deep blue"] = "deep_blue",
			["Green"] = "green",
			["Grey"] = "grey",
			["Orange"] = "orange",
			["Pink"] = "pink",
			["Purple"] = "purple",
			["Red"] = "red",
			["Yellow"] = "yellow"
		},
		editable = false
    }
}

local function addBlockSprites(sprites, themeData, x, y, w, h)
    local ninePatch = drawableNinePatch.fromTexture(themeData, {}, x, y, w, h)
    table.insert(sprites, ninePatch)
end

function jellyBlock.sprite(room, entity)
    local sprites = {}

    local x, y = entity.x or 0, entity.y or 0
    local width, height = entity.width or 16, entity.height or 16
    local size = math.min(width, height)

    local theme = entity.color or "normal"

    local themeData = "objects/FrenchHelper/JellyBlock/" .. theme

    addBlockSprites(sprites, themeData, x, y, width, height)

    return sprites
end



return jellyBlock
