module FrenchHelperFancyTheoCrystal
using ..Ahorn, Maple
using Ahorn.FrenchHelper

@mapdef Entity "FrenchHelper/FancyTheoCrystal" FancyTheoCrystal(x::Integer, y::Integer, crystalColor::String="blue")

const placements = Ahorn.PlacementDict(
    "Fancy Theo Crystal (French Helper)" => Ahorn.EntityPlacement(
        FancyTheoCrystal,
		"point"
    )
)

Ahorn.editingOptions(entity::FancyTheoCrystal) = Dict{String, Any}(
	"crystalColor" => FrenchHelper.fancyTheoCrystalColor,
)

function getSprite(entity::FancyTheoCrystal)
    s = get(entity.data, "crystalColor", "blue")
	return "objects/FrenchHelper/FancyTheoCrystal/" * s * ".png" ;
end

function Ahorn.selection(entity::FancyTheoCrystal)
    x, y = Ahorn.position(entity)

    return Ahorn.getSpriteRectangle(getSprite(entity), x, y)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::FancyTheoCrystal, room::Maple.Room)

	Ahorn.drawSprite(ctx, getSprite(entity), 0, 0)

end

end
