﻿// Example usings.
using Celeste.Mod.UI;
using FMOD.Studio;
using Microsoft.Xna.Framework;
using Monocle;
using Celeste;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MonoMod.Cil;

namespace Celeste.Mod.VelvetCodeSupplement
{
    public class VelvetModule : EverestModule
    {

        // Only one alive module instance can exist at any given time.
        public static VelvetModule Instance;
		private OuiChapterPanel recent;
		public static SpriteBank spriteBank;

		public VelvetModule()
        {
            Instance = this;
        }

        // Check the next section for more information about mod settings, save data and session.
        // Those are optional: if you don't need one of those, you can remove it from the module.



        // Set up any hooks, event handlers and your mod in general here.
        // Load runs before Celeste itself has initialized properly.
        public override void Load()
        {
            IL.Celeste.OuiChapterPanel.Option.ctor += VelvetCustomTag;
			On.Celeste.Player.BoostEnd += CreamHat;
        }

        // Optional, initialize anything after Celeste has initialized itself properly.
        public override void Initialize()
        {
        }

        // Optional, do anything requiring either the Celeste or mod content here.
        public override void LoadContent(bool firstLoad)
        {
			spriteBank = new SpriteBank(GFX.Game, "Graphics/VelvetXmls/Sprites.xml");
		}

        // Unload the entirety of your mod's content. Free up any native resources.
        public override void Unload()
        {
            IL.Celeste.OuiChapterPanel.Option.ctor -= VelvetCustomTag;
			On.Celeste.Player.BoostEnd += CreamHat;
		}

        #region Custom Tag
        private void VelvetCustomTag(ILContext il)
		{
			ILCursor cursor = new ILCursor(il);
			/*ILContext is the IL code for the method (oversimplification)
			  while ILCursor is a cursor that runs through
			  each individual instruction in order. We check the cursor
			  for a specific IL function + data in order to figure out when the cursor reaches a specific
			  instruction, which we can use as a reference point for our code modification.
			  We do this in the next line.*/
			while (cursor.TryGotoNext(MoveType.After, instr => instr.MatchLdstr("areaselect/tab")))
			{
				//At this point in this simple example, we have reached a specific line of code.
				//We wanna pop the old string and replace it with our new string "newText"

				cursor.EmitDelegate<Func<string, string>>(s =>
				{

					if (TryGetChapterPanel(out OuiChapterPanel p))
					{
						if (p.Area.LevelSet == "Velvet/Donker19")
						{

							return "areaselect/Velvet/tab";
						}
					}
					else if (recent != null)
					{
						if (recent.Area.LevelSet == "Velvet/Donker19")
						{
							return "areaselect/Velvet/tab";
						}
					}
					return s;

				});

			}
		}

		private bool TryGetChapterPanel(out OuiChapterPanel panel)
		{
			if (Engine.Scene is Overworld o)
			{
				if (o.Current is OuiChapterPanel current)
				{
					recent = panel = current;
					return true;
				}
				if (o.Next is OuiChapterPanel next)
				{
					recent = panel = next;
					return true;
				}
			}
			else if (recent != null)
			{
				panel = recent;
				return true;
			}
			panel = null;
			return false;
		}
        #endregion Custom Tag

		private void CreamHat(On.Celeste.Player.orig_BoostEnd orig, Player self)
        {
			orig.Invoke(self);
			if(TryGetChapterPanel(out OuiChapterPanel p))
            {
				if (p.Area.LevelSet == "Velvet/Donker19")
				{

					(self.Scene as Level).Add(new AttachedSprite("creamHat", self));
				}
			}
        }

    }
}