﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Xna.Framework;
using Monocle;

namespace Celeste.Mod.VelvetCodeSupplement
{
    public class AttachedSprite : Entity
    {
        private Sprite s;
        private Player p;
        public AttachedSprite(string id, Player p) : base(p.Position)
        {
            Depth = -100;
            Add(s = VelvetModule.spriteBank.Create(id));
            s.Play("melt");
            s.RenderPosition = p.TopCenter;
            this.p = p;
        }
        public override void Update()
        {
            base.Update();
            s.RenderPosition = p.TopCenter-6*Vector2.UnitY;
            if (s.CurrentAnimationID.Equals("dead"))
            {
                RemoveSelf();
            }
        }
    }
}
