function playSprite(sprite, duration)
  player.DummyAutoAnimate = false
  player.Sprite:Play(sprite, false, false)
  if (duration) then
    wait(duration)
    player.DummyAutoAnimate = true
  end
end

-- Parallel coroutine wrapper
local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

function onBegin()
  player.Facing = getEnum("Celeste.Facings", "Right")
  disableMovement()
  player.DummyAutoAnimate = false
  local level = getLevel()
  level:add(coroutineEntity)
  -- These next 2 lines will run in parallel
  coroutineEntity:add(monocle.Coroutine(player.Sprite:Play("sitDown", false, false)))
  coroutineEntity:add(monocle.Coroutine(wait(3)))
  coroutineEntity:add(monocle.Coroutine(completeArea()))
  
end