﻿local drawableSprite = require("structs.drawable_sprite")
local utils = require("utils")

local clutterSwitch = {}

clutterSwitch.name = "CustomClutterHelper/customClutterSwitch"
clutterSwitch.depth = 0
clutterSwitch.placements = {
    name = "clutterSwitch",
    data = {
        clutterFolder = "objects/customclutter/",
        type = "exampleclutter",
        absorbCutsceneSound = "event:/game/03_resort/clutterswitch_books",
        switchSprite = "clutterSwitch",
        progressMusic = true,
        lightingAlphaAdd = 0.05,
        temporaryLightingAlpha = 0.05,
        doTemporaryLightingChanges = true
    }
}

local reverseClutterSwitch = {}

reverseClutterSwitch.name = "CustomClutterHelper/reverseCustomClutterSwitch"
reverseClutterSwitch.depth = 0
reverseClutterSwitch.placements = {
    name = "reverseClutterSwitch",
    data = {
        clutterFolder = "objects/customclutter/",
        type = "exampleclutter",
        absorbCutsceneSound = "event:/game/03_resort/clutterswitch_books",
        switchSprite = "clutterSwitch",
        progressMusic = true,
        lightingAlphaAdd = 0.05,
        temporaryLightingAlpha = 0.05,
        doTemporaryLightingChanges = true
    }
}

local buttonTexture = "objects/resortclutter/clutter_button00"
local clutterTexture = "objects/resortclutter/icon_%s"

function clutterSwitch.sprite(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local variant = entity["type"] or "exampleclutter"

    local buttonSprite = drawableSprite.fromTexture(buttonTexture, entity)
    local clutterSprite = drawableSprite.fromTexture(string.format("%sicon_%s", entity["clutterFolder"], variant), entity)

    buttonSprite:setJustification(0.5, 1.0)
    buttonSprite:addPosition(16, 16)

    if clutterSprite then
        clutterSprite:setJustification(0.5, 0.5)
        clutterSprite:addPosition(16, 8)
    end

    return {
        buttonSprite,
        clutterSprite
    }
end

reverseClutterSwitch.sprite = clutterSwitch.sprite

return {clutterSwitch, reverseClutterSwitch}