--- Showing off callbacks available in the cutscene and brief explanations.
-- You are not required to define anything you aren't using.
-- Leave callbacks global to automatically detect it on c# side.
-- This assumes you know your way around Lua, if you don't then <a href=https://www.lua.org/pil/5.1.html>please consider reading the Lua PIL</a>.
-- <h2>Setting up in map editor</h2>
-- In the case of this cutscene, the filename for the entity field is "Assets/LuaCutscenes/example_cutscene".
-- Please use your own folders for your own cutscenes, like any other Celeste asset collisions can happen.<br>
-- <h2>Using C# in cutscene</h2>
-- Any imports from C# can be done with prefixing # in the require string. For example `local celeste = require("#Celeste")`.<br>
-- Check out helper_functions.lua for examples on C# interaction.
-- @module example_cutscene

--- Coroutine that is called when the cutscene starts.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
function onBegin()
    -- setPlayerState("Crouch")
    disableMovement()
    -- say("CH6_THEO_SAY_VACATION")
    -- jump()
    -- wait(2)

    -- enableMovement()
    --fadeOutMusic(0.5)

    -- Madeline does the breathing while crouching animation
    --local player = getPlayer()
    --player:face(1)  -- Face right
    --player:startCrouchBreathing()  -- Start crouch breathing animation

    -- Wait for a moment to allow the animation to start
    --wait(0.5)

    -- Play dialog
    say("SF_ohno")
    byebyeoshiro(872, 1744, true)
    enableMovement()

    -- Wait for the dialog to complete
    --waitForDialog()

    -- Restore control to the player
    --player:stopCrouchBreathing()  -- Stop crouch breathing animation
    --player:face(1)  -- Make sure the player is still facing right

    -- Optionally, fade in the music again
    --fadeInMusic(1)
end
function byebyeoshiro(pos_x, pos_y, show_burst)

    -- Debug messages
    --debugPrint("Creating Badeline orb at position: " .. pos_x .. ", " .. pos_y)
    --say("Creating Badeline orb at position: " .. pos_x .. ", " .. pos_y)
    --- create and add a new badeline dummy entity
    local position = vector2(pos_x, pos_y)
    badeline_orb = getFirstEntity("Mod.MaxHelpingHand.Entities.MoreCustomNPC")
    if badeline_orb then
        badeline_orb.Visible = false
        badeline_orb.Active = false
    else
        say("tf")
    end
    if show_burst then
      getLevel().Displacement:AddBurst(vector2(pos_x, pos_y), 0.5, 8, 32, 0.5)
    end
    --badeline_orb.nodes[2] = position
    --badeline_orb = celeste.BadelineBoost({position}, false, false, false, false, false)
    --badeline_orb = carpetMod.boost(position)
    --local position = { x = pos_x, y = pos_y }
    --local badeline_orb = celeste.Level:SpawnEntity("carpet/boost", position.x, position.y)
    --if not badeline_orb then
      --say("BadelineBoost creation failed.")
    --else  
      --say("BadelineBoost creation not failed.")
    --end
end

--- Callback for when the cutscene ends.
-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
-- @tparam #Celeste.Level room Current room.
-- @bool wasSkipped If the cutscene was skipped.
function onEnd(room, wasSkipped)
    -- Skipping cutscenes is rude, you know :/
    if wasSkipped then
        byebyeoshiro(872, 1744, false)
        enableMovement()
        -- die()
    end
end